/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.avro.Schema;
import org.talend.daikon.avro.AvroConverter;
import org.talend.daikon.avro.util.ConvertAvroList;
import org.talend.daikon.avro.util.HasNestedAvroConverter;
import org.talend.daikon.avro.util.MappedValueMap;

public class ConvertAvroMap<DatumT, AvroT>
implements HasNestedAvroConverter<Map<String, DatumT>, Map<String, AvroT>> {
    private Schema schema;
    private Class<Map<String, DatumT>> datumClass;
    private final AvroConverter<DatumT, AvroT> elementConverter;

    public ConvertAvroMap(Class<Map<String, DatumT>> datumClass, Schema schema, AvroConverter<DatumT, AvroT> elementConverter) {
        this.datumClass = datumClass;
        this.schema = schema;
        this.elementConverter = elementConverter;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Class<Map<String, DatumT>> getDatumClass() {
        return this.datumClass;
    }

    @Override
    public Map<String, DatumT> convertToDatum(Map<String, AvroT> value) {
        return Collections.unmodifiableMap(new MappedValueMap<String, AvroT, DatumT>(value, new ConvertAvroList.LambdaConvertToDatumFunction<AvroT, DatumT>(this.elementConverter), new ConvertAvroList.LambdaConvertToAvroFunction<DatumT, AvroT>(this.elementConverter)));
    }

    @Override
    public Map<String, AvroT> convertToAvro(Map<String, DatumT> value) {
        return Collections.unmodifiableMap(new MappedValueMap<String, DatumT, AvroT>(value, new ConvertAvroList.LambdaConvertToAvroFunction<DatumT, AvroT>(this.elementConverter), new ConvertAvroList.LambdaConvertToDatumFunction<AvroT, DatumT>(this.elementConverter)));
    }

    @Override
    public Iterable<AvroConverter<?, ?>> getNestedAvroConverters() {
        return Arrays.asList(this.elementConverter);
    }
}

