/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.talend.daikon.avro.AvroConverter;

public class ConvertInetAddress
implements AvroConverter<InetAddress, byte[]> {
    @Override
    public Schema getSchema() {
        return (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.ArrayBuilder)SchemaBuilder.unionOf().array().prop("java-class", this.getDatumClass().getCanonicalName())).items().fixed("Inet4").size(4)).and().fixed("Inet6").size(16)).endUnion();
    }

    @Override
    public Class<InetAddress> getDatumClass() {
        return InetAddress.class;
    }

    @Override
    public InetAddress convertToDatum(byte[] value) {
        try {
            return value == null ? null : InetAddress.getByAddress(value);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] convertToAvro(InetAddress value) {
        return value == null ? null : value.getAddress();
    }
}

