/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.util;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import org.talend.daikon.avro.util.MappedSet;
import org.talend.daikon.java8.Function;
import org.talend.daikon.java8.SerializableFunction;

public class MappedValueMap<KeyT, InT, OutT>
extends AbstractMap<KeyT, OutT> {
    private final Map<KeyT, InT> mWrapped;
    private final Function<InT, OutT> mInFunction;
    private final Function<OutT, InT> mOutFunction;

    MappedValueMap(Map<KeyT, InT> wrapped, Function<InT, OutT> inFunction, Function<OutT, InT> outFunction) {
        this.mWrapped = wrapped;
        this.mInFunction = inFunction;
        this.mOutFunction = outFunction;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mWrapped.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mWrapped.containsValue(this.mOutFunction.apply(value));
    }

    @Override
    public Set<KeyT> keySet() {
        return this.mWrapped.keySet();
    }

    @Override
    public OutT get(Object key) {
        return this.mInFunction.apply(this.mWrapped.get(key));
    }

    @Override
    public Set<Map.Entry<KeyT, OutT>> entrySet() {
        Set<Map.Entry<KeyT, InT>> in = this.mWrapped.entrySet();
        return new MappedSet(in, new LambdaConvertToMappedValueEntry(), new LambdaUnwrapMappedValueEntry());
    }

    private class MappedValueEntry
    implements Map.Entry<KeyT, OutT> {
        private final Map.Entry<KeyT, InT> mWrappedEntry;

        public MappedValueEntry(Map.Entry<KeyT, InT> wrappedEntry) {
            this.mWrappedEntry = wrappedEntry;
        }

        Map.Entry<KeyT, InT> getWrapped() {
            return this.mWrappedEntry;
        }

        @Override
        public KeyT getKey() {
            return this.mWrappedEntry.getKey();
        }

        @Override
        public OutT getValue() {
            return MappedValueMap.this.mInFunction.apply(this.mWrappedEntry.getValue());
        }

        @Override
        public OutT setValue(OutT value) {
            return MappedValueMap.this.mInFunction.apply(this.mWrappedEntry.setValue(MappedValueMap.this.mOutFunction.apply(value)));
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }

    private class LambdaUnwrapMappedValueEntry
    implements SerializableFunction<Map.Entry<KeyT, OutT>, Map.Entry<KeyT, InT>> {
        private static final long serialVersionUID = 1L;

        private LambdaUnwrapMappedValueEntry() {
        }

        @Override
        public Map.Entry<KeyT, InT> apply(Map.Entry<KeyT, OutT> t) {
            return ((MappedValueEntry)t).getWrapped();
        }
    }

    private class LambdaConvertToMappedValueEntry
    implements SerializableFunction<Map.Entry<KeyT, InT>, Map.Entry<KeyT, OutT>> {
        private static final long serialVersionUID = 1L;

        private LambdaConvertToMappedValueEntry() {
        }

        @Override
        public Map.Entry<KeyT, OutT> apply(Map.Entry<KeyT, InT> t) {
            return new MappedValueEntry(t);
        }
    }
}

