/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.avro.util;

import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.IndexedRecordAdapterFactory;

public class SingleColumnIndexedRecordAdapterFactory<DatumT>
implements IndexedRecordAdapterFactory<DatumT, PrimitiveAsIndexedRecordAdapter<DatumT>> {
    private final Class<DatumT> mDatumClass;
    private final Schema mSchema;

    public SingleColumnIndexedRecordAdapterFactory(Class<DatumT> datumClass, Schema schema) {
        this.mDatumClass = datumClass;
        this.mSchema = (Schema)SchemaBuilder.record((String)(datumClass.getSimpleName() + "Record")).fields().name("field1").type(schema).noDefault().endRecord();
    }

    @Override
    public Class<DatumT> getDatumClass() {
        return this.mDatumClass;
    }

    @Override
    public Schema getSchema() {
        return this.mSchema;
    }

    @Override
    public void setSchema(Schema s) {
        throw new IndexedRecordAdapterFactory.UnmodifiableAdapterException();
    }

    @Override
    public PrimitiveAsIndexedRecordAdapter<DatumT> convertToAvro(DatumT value) {
        return new PrimitiveAsIndexedRecordAdapter(this.mSchema, value);
    }

    @Override
    public DatumT convertToDatum(PrimitiveAsIndexedRecordAdapter<DatumT> value) {
        return (DatumT)((PrimitiveAsIndexedRecordAdapter)value).mValue;
    }

    public static class PrimitiveAsIndexedRecordAdapter<T>
    implements IndexedRecord {
        private final T mValue;
        private final Schema mSchema;

        private PrimitiveAsIndexedRecordAdapter(Schema schema, T value) {
            this.mSchema = schema;
            this.mValue = value;
        }

        public Schema getSchema() {
            return this.mSchema;
        }

        public T get(int i) {
            return this.mValue;
        }

        public void put(int i, Object v) {
            throw new IndexedRecordAdapterFactory.UnmodifiableAdapterException();
        }
    }
}

