/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.exception;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.exception.json.JsonErrorCode;

public class TalendRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -5306654994356243153L;
    private static final Logger LOGGER = LoggerFactory.getLogger(TalendRuntimeException.class);
    private final ErrorCode code;
    private final Throwable cause;
    private final ExceptionContext context;

    public TalendRuntimeException(ErrorCode code, Throwable cause, ExceptionContext context) {
        super(code.getCode() + (context != null ? ":" + context.toString() : ""), cause);
        this.code = code;
        this.cause = cause;
        this.context = context == null ? ExceptionContext.build() : context;
        this.checkContext();
    }

    public TalendRuntimeException(ErrorCode code, Throwable cause) {
        this(code, cause, null);
    }

    public TalendRuntimeException(ErrorCode code, ExceptionContext context) {
        this(code, null, context);
    }

    public TalendRuntimeException(JsonErrorCode code) {
        this((ErrorCode)code, ExceptionContext.build().from(code.getContext()));
    }

    public TalendRuntimeException(ErrorCode code) {
        this(code, null, null);
    }

    public static void unexpectedException(Throwable cause) {
        throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, cause);
    }

    public static void unexpectedException(String message) {
        throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, ExceptionContext.build().put("message", message));
    }

    private void checkContext() {
        ArrayList<String> missingEntries = new ArrayList<String>();
        for (String expectedEntry : this.code.getExpectedContextEntries()) {
            if (this.context.contains(expectedEntry)) continue;
            missingEntries.add(expectedEntry);
        }
        if (missingEntries.size() > 0) {
            LOGGER.warn("TDPException context for {}, is missing the given entry(ies) \n{}. \nStacktrace for info", new Object[]{this.code.getCode(), missingEntries, this});
        }
    }

    public void writeTo(Writer writer) {
        try {
            JsonGenerator generator = new JsonFactory().createGenerator(writer);
            generator.writeStartObject();
            generator.writeStringField("code", this.code.getProduct() + '_' + this.code.getGroup() + '_' + this.code.getCode());
            generator.writeStringField("message", this.code.getCode());
            if (this.cause != null) {
                generator.writeStringField("cause", this.cause.getMessage());
            }
            if (this.context != null) {
                generator.writeFieldName("context");
                generator.writeStartObject();
                for (Map.Entry<String, Object> entry : this.context.entries()) {
                    generator.writeStringField(entry.getKey(), entry.getValue().toString());
                }
                generator.writeEndObject();
            }
            generator.writeEndObject();
            generator.flush();
        }
        catch (IOException e) {
            LOGGER.error("Unable to write exception to " + writer + ".", (Throwable)e);
        }
    }

    public ErrorCode getCode() {
        return this.code;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    public ExceptionContext getContext() {
        return this.context;
    }
}

