/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.exception.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;

public class JsonErrorCode
implements ErrorCode {
    private static final long serialVersionUID = 2244078854888080512L;
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="context")
    private Map<String, Object> context = Collections.emptyMap();
    private int httpStatus;

    @Override
    public String getProduct() {
        return StringUtils.substringBefore((String)this.code, (String)"_");
    }

    public void setProduct(String product) {
    }

    @Override
    public String getGroup() {
        return StringUtils.substringBefore((String)StringUtils.substringAfter((String)this.code, (String)"_"), (String)"_");
    }

    public void setGroup(String group) {
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return CommonErrorCodes.UNEXPECTED_EXCEPTION.getCode();
        }
        return this.code.substring((this.getProduct() + '_' + this.getGroup()).length() + 1);
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public int getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    @Override
    public Collection<String> getExpectedContextEntries() {
        return this.context.keySet();
    }
}

