/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.talend.daikon.i18n.LocaleProvider;

public abstract class I18nMessages {
    transient MessageFormat formatter = new MessageFormat("");
    transient LocaleProvider localeProvider;

    public I18nMessages(LocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    public abstract String getMessage(String var1, Object ... var2);

    protected Locale getLocale() {
        if (this.localeProvider != null) {
            Locale locale = this.localeProvider.getLocale();
            return locale != null ? locale : Locale.getDefault();
        }
        return Locale.getDefault();
    }

    protected String getFormattedMessage(String key, ClassLoader classLoader, String baseName, Object ... arguments) throws MissingResourceException {
        Locale locale = this.getLocale();
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, classLoader);
        String bundleValue = bundle.getString(key);
        this.formatter.setLocale(locale);
        this.formatter.applyPattern(bundleValue);
        return this.formatter.format(arguments);
    }
}

