/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.i18n;

import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.i18n.GlobalI18N;
import org.talend.daikon.i18n.I18nMessages;
import org.talend.daikon.i18n.Translatable;

public class TranslatableImpl
implements Translatable {
    private transient I18nMessages i18nMessages;

    @Override
    public void setI18nMessageFormater(I18nMessages i18nMessages) {
        this.i18nMessages = i18nMessages;
    }

    public I18nMessages getI18nMessageFormater() {
        if (this.i18nMessages == null) {
            this.i18nMessages = this.createI18nMessageFormater();
        }
        return this.i18nMessages;
    }

    protected I18nMessages createI18nMessageFormater() {
        return GlobalI18N.getI18nMessageProvider().getI18nMessages(this.getClass());
    }

    @Override
    public String getI18nMessage(String key, Object ... arguments) {
        I18nMessages i18nMessageFormater = this.getI18nMessageFormater();
        if (i18nMessageFormater != null) {
            return i18nMessageFormater.getMessage(key, arguments);
        }
        throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.MISSING_I18N_TRANSLATOR, ExceptionContext.build().put("key", key));
    }
}

