/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.talend.daikon.NamedThing;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.CommonErrorCodes;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.i18n.TranslatableImpl;
import org.talend.daikon.properties.AnyProperty;
import org.talend.daikon.properties.AnyPropertyVisitor;
import org.talend.daikon.properties.MigrationInformation;
import org.talend.daikon.properties.Property;
import org.talend.daikon.properties.PropertyValueEvaluator;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.error.PropertiesErrorCode;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.security.CryptoHelper;
import org.talend.daikon.strings.ToStringIndent;
import org.talend.daikon.strings.ToStringIndentUtil;

public abstract class Properties
extends TranslatableImpl
implements AnyProperty,
ToStringIndent {
    static final String METHOD_BEFORE = "before";
    static final String METHOD_AFTER = "after";
    static final String METHOD_VALIDATE = "validate";
    static final String METHOD_BEFORE_FORM = "beforeFormPresent";
    static final String METHOD_AFTER_FORM_BACK = "afterFormBack";
    static final String METHOD_AFTER_FORM_NEXT = "afterFormNext";
    static final String METHOD_AFTER_FORM_FINISH = "afterFormFinish";
    private String name;
    private List<Form> forms = new ArrayList<Form>();
    ValidationResult validationResult;
    private transient boolean layoutAlreadyInitalized;
    private transient boolean propsAlreadyInitialized;
    protected static final boolean ENCRYPT = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized <T extends Properties> Deserialized<T> fromSerialized(String serialized, Class<T> propertiesclass) {
        Deserialized d = new Deserialized();
        d.migration = new MigrationInformationImpl();
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Properties.class.getClassLoader());
            d.properties = (Properties)JsonReader.jsonToJava((String)serialized);
            ((Properties)d.properties).handlePropEncryption(false);
            ((Properties)d.properties).setupPropertiesPostDeserialization();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
        return d;
    }

    void setupPropertiesPostDeserialization() {
        this.initLayout();
        List<NamedThing> properties = this.getProperties();
        for (NamedThing prop : properties) {
            if (prop instanceof Properties) {
                ((Properties)prop).setupPropertiesPostDeserialization();
                continue;
            }
            prop.setI18nMessageFormater(this.getI18nMessageFormater());
        }
    }

    public Properties(String name) {
        this.setName(name);
    }

    public Properties init() {
        this.initProperties();
        this.initLayout();
        return this;
    }

    public Properties initForRuntime() {
        this.initProperties();
        return this;
    }

    private void initProperties() {
        if (!this.propsAlreadyInitialized) {
            ArrayList<Field> uninitializedProperties = new ArrayList<Field>();
            Field[] fields = this.getClass().getFields();
            for (Field f : fields) {
                try {
                    if (!this.isAPropertyType(f.getType())) continue;
                    f.setAccessible(true);
                    NamedThing se = (NamedThing)f.get(this);
                    if (se != null) {
                        this.initializeField(f, se);
                        continue;
                    }
                    uninitializedProperties.add(f);
                }
                catch (IllegalAccessException e) {
                    throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
                }
            }
            this.setupProperties();
            for (Field f : uninitializedProperties) {
                try {
                    f.setAccessible(true);
                    NamedThing se = (NamedThing)f.get(this);
                    if (se != null) {
                        this.initializeField(f, se);
                        continue;
                    }
                    if (this.acceptUninitializedField(f)) continue;
                    throw new TalendRuntimeException((ErrorCode)PropertiesErrorCode.PROPERTIES_HAS_UNITIALIZED_PROPS, ExceptionContext.withBuilder().put("name", this.getClass().getCanonicalName()).put("field", f.getName()).build());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
                }
            }
            this.propsAlreadyInitialized = true;
        }
    }

    protected boolean acceptUninitializedField(Field f) {
        return false;
    }

    public void initializeField(Field f, NamedThing value) {
        if (!f.getName().equals(value.getName())) {
            throw new IllegalArgumentException("The java field [" + this.getClass().getCanonicalName() + "." + f.getName() + "] should be named identically to the instance name [" + value.getName() + "]");
        }
        if (value instanceof Property) {
            value.setI18nMessageFormater(this.getI18nMessageFormater());
        } else {
            ((Properties)value).initProperties();
        }
    }

    private void initLayout() {
        if (!this.layoutAlreadyInitalized) {
            List<NamedThing> properties = this.getProperties();
            for (NamedThing prop : properties) {
                if (!(prop instanceof Properties)) continue;
                ((Properties)prop).initLayout();
            }
            this.setupLayout();
            for (Form form : this.getForms()) {
                this.refreshLayout(form);
            }
            this.layoutAlreadyInitalized = true;
        }
    }

    public void setupProperties() {
    }

    public void setupLayout() {
    }

    public String toSerialized() {
        this.handlePropEncryption(true);
        List<Form> currentForms = this.forms;
        String ser = null;
        try {
            this.forms = new ArrayList<Form>();
            ser = JsonWriter.objectToJson((Object)this);
        }
        finally {
            this.forms = currentForms;
        }
        this.handlePropEncryption(false);
        return ser;
    }

    protected void handlePropEncryption(final boolean encrypt) {
        this.accept(new AnyPropertyVisitor(){

            @Override
            public void visit(Properties properties, Properties parent) {
            }

            @Override
            public void visit(Property property, Properties parent) {
                if (property.isFlag(Property.Flags.ENCRYPT)) {
                    String value = (String)property.getStoredValue();
                    CryptoHelper ch = new CryptoHelper("99ZwBDt1L9yMX2ApJx fnv94o99OeHbCGuIHTy22 V9O6cZ2i374fVjdV76VX9g49DG1r3n90hT5c1");
                    if (encrypt) {
                        property.setValue(ch.encrypt(value));
                    } else {
                        property.setValue(ch.decrypt(value));
                    }
                }
            }
        }, null);
    }

    public void refreshLayout(Form form) {
        form.setRefreshUI(true);
    }

    public List<Form> getForms() {
        return this.forms;
    }

    public Form getForm(String formName) {
        for (Form f : this.forms) {
            if (!f.getName().equals(formName)) continue;
            return f;
        }
        return null;
    }

    public String getSimpleClassName() {
        return this.getClass().getSimpleName();
    }

    public void addForm(Form form) {
        this.forms.add(form);
    }

    public List<NamedThing> getProperties() {
        ArrayList<NamedThing> properties = new ArrayList<NamedThing>();
        List<Field> propertyFields = this.getAnyPropertyFields();
        for (Field f : propertyFields) {
            try {
                if (!NamedThing.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                Object fValue = f.get(this);
                if (fValue == null) continue;
                NamedThing se = (NamedThing)fValue;
                properties.add(se);
            }
            catch (IllegalAccessException e) {
                throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
            }
        }
        return properties;
    }

    private List<Field> getAnyPropertyFields() {
        Field[] fields;
        ArrayList<Field> propertyFields = new ArrayList<Field>();
        for (Field f : fields = this.getClass().getFields()) {
            if (!this.isAPropertyType(f.getType())) continue;
            propertyFields.add(f);
        }
        return propertyFields;
    }

    @Override
    public void accept(AnyPropertyVisitor visitor, Properties parent) {
        List<NamedThing> properties = this.getProperties();
        for (NamedThing nt : properties) {
            if (!(nt instanceof AnyProperty)) continue;
            ((AnyProperty)nt).accept(visitor, this);
        }
        visitor.visit(this, parent);
    }

    protected boolean isAPropertyType(Class<?> clazz) {
        return AnyProperty.class.isAssignableFrom(clazz);
    }

    public NamedThing getProperty(String name) {
        String[] propComps = name.split("\\.");
        Properties currentProps = this;
        int i = 0;
        for (String prop : propComps) {
            if (i++ == propComps.length - 1) {
                return currentProps.getLocalProperty(prop);
            }
            NamedThing se = currentProps.getLocalProperty(prop);
            if (!(se instanceof Properties)) {
                return null;
            }
            currentProps = (Properties)se;
        }
        return null;
    }

    public Property getValuedProperty(String propPath) {
        NamedThing prop = this.getProperty(propPath);
        return prop instanceof Property ? (Property)prop : null;
    }

    public Properties getProperties(String propPath) {
        NamedThing prop = this.getProperty(propPath);
        return prop instanceof Properties ? (Properties)prop : null;
    }

    protected NamedThing getLocalProperty(String name) {
        List<NamedThing> properties = this.getProperties();
        for (NamedThing prop : properties) {
            if (!name.equals(prop.getName())) continue;
            return prop;
        }
        return null;
    }

    public void setValue(String property, Object value) {
        NamedThing p = this.getProperty(property);
        if (!(p instanceof Property)) {
            throw new IllegalArgumentException("setValue but property: " + property + " is not a Property");
        }
        ((Property)p).setValue(value);
    }

    public void setValueEvaluator(PropertyValueEvaluator ve) {
        List<NamedThing> properties = this.getProperties();
        for (NamedThing prop : properties) {
            if (prop instanceof Property) {
                ((Property)prop).setValueEvaluator(ve);
                continue;
            }
            if (!(prop instanceof Properties)) continue;
            ((Properties)prop).setValueEvaluator(ve);
        }
    }

    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public void assignNestedProperties(Properties ... newValueProperties) {
        List<Field> propertyFields = this.getAnyPropertyFields();
        for (Field propField : propertyFields) {
            Class<?> propType = propField.getType();
            if (!Properties.class.isAssignableFrom(propType)) continue;
            boolean isNewAssignment = false;
            for (Properties newValue : newValueProperties) {
                if (!propType.isAssignableFrom(newValue.getClass())) continue;
                try {
                    propField.set(this, newValue);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
                }
                isNewAssignment = true;
            }
            if (isNewAssignment) continue;
            try {
                Properties prop = (Properties)propField.get(this);
                if (prop == null) continue;
                prop.assignNestedProperties(newValueProperties);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new TalendRuntimeException((ErrorCode)CommonErrorCodes.UNEXPECTED_EXCEPTION, (Throwable)e);
            }
        }
    }

    public void copyValuesFrom(Properties props) {
        for (NamedThing otherProp : props.getProperties()) {
            NamedThing thisProp = this.getProperty(otherProp.getName());
            if (thisProp == null) {
                try {
                    Class<?> otherClass = otherProp.getClass();
                    if (Property.class.isAssignableFrom(otherClass)) {
                        Constructor<?> c = otherClass.getConstructor(String.class);
                        thisProp = (NamedThing)c.newInstance(otherProp.getName());
                    } else if (Properties.class.isAssignableFrom(otherClass)) {
                        Constructor<?>[] constructors;
                        for (Constructor<?> c : constructors = otherClass.getConstructors()) {
                            Class<?>[] pts = c.getParameterTypes();
                            if (pts.length == 1 && String.class.isAssignableFrom(pts[0])) {
                                thisProp = (NamedThing)c.newInstance(otherProp.getName());
                            } else {
                                if (pts.length != 2 || !Properties.class.isAssignableFrom(pts[0]) || !String.class.isAssignableFrom(pts[1])) continue;
                                thisProp = (NamedThing)c.newInstance(this, otherProp.getName());
                            }
                            break;
                        }
                    } else {
                        TalendRuntimeException.unexpectedException("Unexpected property class: " + otherProp.getClass() + " prop: " + otherProp);
                    }
                    try {
                        Field f = this.getClass().getField(otherProp.getName());
                        f.set(this, thisProp);
                    }
                    catch (NoSuchFieldException e) {
                        continue;
                    }
                }
                catch (Exception e) {
                    TalendRuntimeException.unexpectedException(e);
                }
            }
            if (otherProp instanceof Properties) {
                ((Properties)thisProp).copyValuesFrom((Properties)otherProp);
                continue;
            }
            Object value = ((Property)otherProp).getStoredValue();
            ((Property)thisProp).setValue(value);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Properties setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String getDisplayName() {
        return this.getI18nMessage("properties" + (this.getName() == null ? this.getName() : "") + ".displayName", new Object[0]);
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    public String toString() {
        return this.toStringIndent(0);
    }

    @Override
    public String toStringIndent(int indent) {
        StringBuilder sb = new StringBuilder();
        String is = ToStringIndentUtil.indentString(indent);
        sb.append(is + this.getName() + " - " + this.getTitle() + " " + this.getClass().getName());
        sb.append("\n" + is + "   Properties:");
        for (NamedThing prop : this.getProperties()) {
            String value;
            if (prop instanceof ToStringIndent) {
                sb.append('\n' + ((ToStringIndent)((Object)prop)).toStringIndent(indent + 6));
            } else {
                sb.append('\n' + prop.toString());
            }
            if ((value = prop instanceof Property ? ((Property)prop).getStringValue() : null) == null) continue;
            sb.append(" [" + value + "]");
        }
        sb.append("\n " + is + "  Forms:");
        for (Form form : this.getForms()) {
            sb.append("\n" + form.toStringIndent(indent + 6));
        }
        return sb.toString();
    }

    public static class MigrationInformationImpl
    implements MigrationInformation {
        @Override
        public boolean isMigrated() {
            return false;
        }

        @Override
        public String getVersion() {
            return null;
        }
    }

    public static class Deserialized<T extends Properties> {
        public T properties;
        public MigrationInformation migration;
    }
}

