/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.ValidationResult;
import org.talend.daikon.properties.error.PropertiesErrorCode;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.properties.service.Repository;

public class PropertiesDynamicMethodHelper {
    static boolean REQUIRED = true;

    static Method findMethod(Object obj, String type, String propertyName, boolean required) {
        Method[] methods;
        if (propertyName == null || "".equals(propertyName)) {
            throw new IllegalArgumentException("The ComponentService was used to access a property with a null(or empty) property name. Type: " + type + " Properties: " + obj);
        }
        String propName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        String methodName = type + propName;
        for (Method m : methods = obj.getClass().getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        if (required) {
            throw new IllegalStateException("Method: " + methodName + " not found");
        }
        return null;
    }

    static void doInvoke(Properties props, Method m) throws Throwable {
        try {
            Object result = m.invoke((Object)props, new Object[0]);
            PropertiesDynamicMethodHelper.storeResult(props, result);
        }
        catch (InvocationTargetException e) {
            throw new TalendRuntimeException(PropertiesErrorCode.FAILED_INVOKE_METHOD, e, ExceptionContext.withBuilder().put("class", m.getDeclaringClass().getCanonicalName()).put("method", m.getName()).build());
        }
    }

    public static void storeResult(Properties props, Object result) {
        props.validationResult = result instanceof ValidationResult && result != null ? (ValidationResult)result : ValidationResult.OK;
    }

    static void doInvoke(Properties props, Method m, Object ... arguments) throws Throwable {
        try {
            Object result = m.invoke((Object)props, arguments);
            PropertiesDynamicMethodHelper.storeResult(props, result);
        }
        catch (IllegalArgumentException | InvocationTargetException e) {
            throw new TalendRuntimeException(PropertiesErrorCode.FAILED_INVOKE_METHOD, e, ExceptionContext.withBuilder().put("class", m.getDeclaringClass().getCanonicalName()).put("method", m.getName()).build());
        }
    }

    public static void validateProperty(Properties props, String propName) throws Throwable {
        Method m = PropertiesDynamicMethodHelper.findMethod(props, "validate", propName, REQUIRED);
        try {
            props.validationResult = (ValidationResult)m.invoke((Object)props, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static void beforePropertyActivate(Properties props, String propName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "before", propName, REQUIRED));
    }

    public static void beforePropertyPresent(Properties props, String propName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "before", propName, REQUIRED));
    }

    public static void afterProperty(Properties props, String propName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "after", propName, REQUIRED));
    }

    public static void beforeFormPresent(Properties props, String formName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "beforeFormPresent", formName, REQUIRED));
    }

    public static void afterFormNext(Properties props, String formName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "afterFormNext", formName, REQUIRED));
    }

    public static void afterFormBack(Properties props, String formName) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "afterFormBack", formName, REQUIRED));
    }

    public static void afterFormFinish(Properties props, String formName, Repository repostory) throws Throwable {
        PropertiesDynamicMethodHelper.doInvoke(props, PropertiesDynamicMethodHelper.findMethod(props, "afterFormFinish", formName, REQUIRED), repostory);
    }

    public static void setFormLayoutMethods(Properties props, String property, Form form) {
        Method m = PropertiesDynamicMethodHelper.findMethod(props, "beforeFormPresent", property, !REQUIRED);
        if (m != null) {
            form.setCallBeforeFormPresent(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "afterFormBack", property, !REQUIRED)) != null) {
            form.setCallAfterFormBack(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "afterFormNext", property, !REQUIRED)) != null) {
            form.setCallAfterFormNext(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "afterFormFinish", property, !REQUIRED)) != null) {
            form.setCallAfterFormFinish(true);
        }
    }

    public static void setWidgetLayoutMethods(Properties props, String property, Widget widget) {
        Method m = PropertiesDynamicMethodHelper.findMethod(props, "before", property, !REQUIRED);
        if (m != null) {
            widget.setCallBefore(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "after", property, !REQUIRED)) != null) {
            widget.setCallAfter(true);
        }
        if ((m = PropertiesDynamicMethodHelper.findMethod(props, "validate", property, !REQUIRED)) != null) {
            widget.setCallValidate(true);
        }
    }
}

