/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.talend.daikon.SimpleNamedThing;
import org.talend.daikon.properties.AnyProperty;
import org.talend.daikon.properties.AnyPropertyVisitor;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertyValueEvaluator;
import org.talend.daikon.strings.ToStringIndentUtil;

public class Property
extends SimpleNamedThing
implements AnyProperty {
    private static final String I18N_PROPERTY_PREFIX = "property.";
    public static int INFINITE = -1;
    protected EnumSet<Flags> flags;
    private Map<String, Object> taggedValues = new HashMap<String, Object>();
    private Object storedValue;
    private transient PropertyValueEvaluator propertyValueEvaluator;
    private Type type;
    private int size;
    private int occurMinTimes;
    private int occurMaxTimes;
    private int precision;
    private String pattern;
    private String defaultValue;
    private boolean nullable;
    private Class<?> enumClass;
    private List<?> possibleValues;
    protected List<Property> children = new ArrayList<Property>();

    public Property(String name, String title) {
        this((Type)null, name, title);
    }

    public Property(Type type, String name, String title) {
        this.setName(name);
        this.setType(type == null ? Type.STRING : type);
        this.setTitle(title);
        this.setSize(-1);
    }

    public Property(Type type, String name) {
        this(type, name, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Property setName(String name) {
        this.name = name;
        return this;
    }

    public Property setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Property setTitle(String title) {
        this.title = title;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Property setType(Type type) {
        this.type = type;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Property setSize(int size) {
        this.size = size;
        return this;
    }

    public boolean isSizeUnbounded() {
        return this.size == -1;
    }

    public int getOccurMinTimes() {
        return this.occurMinTimes;
    }

    public Property setOccurMinTimes(int times) {
        this.occurMinTimes = times;
        return this;
    }

    public int getOccurMaxTimes() {
        return this.occurMaxTimes;
    }

    public Property setOccurMaxTimes(int times) {
        this.occurMaxTimes = times;
        return this;
    }

    public boolean isRequired() {
        return this.occurMinTimes > 0;
    }

    public Property setRequired() {
        return this.setRequired(true);
    }

    public Property setRequired(boolean required) {
        this.setOccurMinTimes(1);
        this.setOccurMaxTimes(1);
        return this;
    }

    public int getPrecision() {
        return this.precision;
    }

    public Property setPrecision(int precision) {
        this.precision = precision;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Property setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Property setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public Property setNullable(boolean nullable) {
        this.nullable = nullable;
        return this;
    }

    public Class<?> getEnumClass() {
        return this.enumClass;
    }

    public Property setEnumClass(Class<?> enumClass) {
        this.enumClass = enumClass;
        return this;
    }

    public List<?> getPossibleValues() {
        return this.possibleValues;
    }

    @JsonIgnore
    public Property setPossibleValues(List<?> possibleValues) {
        this.possibleValues = possibleValues;
        return this;
    }

    public Property setPossibleValues(Object ... values) {
        this.possibleValues = Arrays.asList(values);
        return this;
    }

    public List<Property> getChildren() {
        return this.children;
    }

    public Property setChildren(List<Property> children) {
        this.children = children;
        return this;
    }

    public Property addChild(Property child) {
        this.children.add(child);
        return this;
    }

    public Property getChild(String name) {
        if (this.children != null) {
            for (Property child : this.children) {
                if (!child.getName().equals(name)) continue;
                return child;
            }
        }
        return null;
    }

    public Map<String, Property> getChildMap() {
        HashMap<String, Property> map = new HashMap<String, Property>();
        for (Property se : this.getChildren()) {
            map.put(se.getName(), se);
        }
        return map;
    }

    public Property(String name) {
        this(name, null);
    }

    public EnumSet<Flags> getFlags() {
        return this.flags;
    }

    public Property setFlags(EnumSet<Flags> flags) {
        this.flags = flags;
        return this;
    }

    public boolean isFlag(Flags flag) {
        if (this.flags == null) {
            return false;
        }
        return this.flags.contains((Object)flag);
    }

    public void setValue(Object value) {
        Object valueToSet = value;
        if (value != null && this.getType() == Type.SCHEMA && value instanceof Schema) {
            valueToSet = value.toString();
        }
        this.storedValue = valueToSet;
    }

    public Object getStoredValue() {
        return this.storedValue;
    }

    public Object getValue() {
        if (this.propertyValueEvaluator != null) {
            return this.propertyValueEvaluator.evaluate(this, this.storedValue);
        }
        return this.storedValue;
    }

    public boolean getBooleanValue() {
        return Boolean.valueOf(String.valueOf(this.getValue()));
    }

    public String getStringValue() {
        Object value = this.getValue();
        if (value != null) {
            return String.valueOf(value);
        }
        return null;
    }

    public int getIntValue() {
        Object value = this.getValue();
        if (value == null) {
            return 0;
        }
        return Integer.valueOf(String.valueOf(value));
    }

    public Calendar getCalendarValue() {
        Object value = this.getValue();
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            return calendar;
        }
        throw new IllegalStateException(this + " is not instance of Date nor Calendar");
    }

    @Override
    public String toString() {
        return "Property: " + this.getName();
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getI18nMessage(I18N_PROPERTY_PREFIX + this.name + ".displayName", new Object[0]);
    }

    public void setTaggedValue(String key, Object value) {
        this.taggedValues.put(key, value);
    }

    public Object getTaggedValue(String key) {
        return this.taggedValues.get(key);
    }

    public void setValueEvaluator(PropertyValueEvaluator ve) {
        this.propertyValueEvaluator = ve;
    }

    @Override
    public void accept(AnyPropertyVisitor visitor, Properties parent) {
        visitor.visit(this, parent);
    }

    public String toStringIndent(int indent) {
        return ToStringIndentUtil.indentString(indent) + this.getName();
    }

    public static enum Flags {
        ENCRYPT,
        SUPPRESS_LOGGING,
        DESIGN_TIME_ONLY;

    }

    public static enum Type {
        STRING,
        BOOLEAN,
        INT,
        DATE,
        DATETIME,
        DECIMAL,
        FLOAT,
        DOUBLE,
        BYTE_ARRAY,
        ENUM,
        DYNAMIC,
        GROUP,
        SCHEMA;

    }
}

