/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties;

import org.talend.daikon.properties.Property;

public class PropertyFactory {
    public static Property newProperty(String name) {
        return new Property(name);
    }

    public static Property newProperty(String name, String title) {
        return new Property(name, title);
    }

    public static Property newProperty(Property.Type type, String name, String title) {
        return new Property(type, name, title);
    }

    public static Property newProperty(Property.Type type, String name) {
        return new Property(type, name);
    }

    public static Property newString(String name) {
        return new Property(Property.Type.STRING, name);
    }

    public static Property newInteger(String name) {
        return new Property(Property.Type.INT, name);
    }

    public static Property newInteger(String name, String defaultValue) {
        Property property = PropertyFactory.newInteger(name);
        property.setDefaultValue(defaultValue);
        return property;
    }

    public static Property newInteger(String name, Integer defaultValue) {
        return PropertyFactory.newInteger(name, defaultValue.toString());
    }

    public static Property newDouble(String name) {
        return new Property(Property.Type.DOUBLE, name);
    }

    public static Property newDouble(String name, String defaultValue) {
        Property property = PropertyFactory.newDouble(name);
        property.setDefaultValue(defaultValue);
        return property;
    }

    public static Property newDouble(String name, Double defaultValue) {
        return PropertyFactory.newDouble(name, defaultValue.toString());
    }

    public static Property newFloat(String name) {
        return new Property(Property.Type.FLOAT, name);
    }

    public static Property newFloat(String name, String defaultValue) {
        Property property = PropertyFactory.newFloat(name);
        property.setDefaultValue(defaultValue);
        return property;
    }

    public static Property newFloat(String name, Float defaultValue) {
        return PropertyFactory.newFloat(name, defaultValue.toString());
    }

    public static Property newBoolean(String name) {
        return new Property(Property.Type.BOOLEAN, name);
    }

    public static Property newBoolean(String name, String defaultValue) {
        Property property = PropertyFactory.newBoolean(name);
        property.setDefaultValue(defaultValue);
        return property;
    }

    public static Property newBoolean(String name, Boolean defaultValue) {
        return PropertyFactory.newBoolean(name, defaultValue.toString());
    }

    public static Property newDate(String name) {
        return new Property(Property.Type.DATE, name);
    }

    public static Property newEnum(String name) {
        return new Property(Property.Type.ENUM, name);
    }

    public static Property newEnum(String name, Object ... values) {
        Property property = new Property(Property.Type.ENUM, name);
        property.setPossibleValues(values);
        return property;
    }
}

