/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.presentation;

import com.fasterxml.jackson.annotation.JsonBackReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.talend.daikon.NamedThing;
import org.talend.daikon.SimpleNamedThing;
import org.talend.daikon.i18n.GlobalI18N;
import org.talend.daikon.i18n.I18nMessages;
import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesDynamicMethodHelper;
import org.talend.daikon.properties.Property;
import org.talend.daikon.properties.presentation.Widget;
import org.talend.daikon.strings.ToStringIndent;
import org.talend.daikon.strings.ToStringIndentUtil;

public class Form
extends SimpleNamedThing
implements ToStringIndent {
    public static final String I18N_FORM_PREFIX = "form.";
    public static final String MAIN = "Main";
    public static final String ADVANCED = "Advanced";
    public static final String REFERENCE = "Reference";
    public static final String I18N_SUBTITLE_NAME_SUFFIX = ".subtitle";
    protected String subtitle;
    @JsonBackReference
    protected Properties properties;
    protected LinkedHashMap<String, Widget> widgetMap;
    private transient int lastRow;
    private transient int lastColumn;
    private boolean cancelable;
    private Map<String, Object> originalValues;
    private boolean callBeforeFormPresent;
    private boolean callAfterFormBack;
    private boolean callAfterFormNext;
    private boolean callAfterFormFinish;
    private boolean allowBack;
    private boolean allowForward;
    private boolean allowFinish;
    protected boolean refreshUI;

    public Form() {
    }

    public Form(Properties props, String name, String displayName, String title) {
        super(name, displayName, title);
        this.widgetMap = new LinkedHashMap();
        props.addForm(this);
        this.properties = props;
        PropertiesDynamicMethodHelper.setFormLayoutMethods(props, name, this);
    }

    public Form(Properties props, String name) {
        this(props, name, name, null);
    }

    public static Form create(Properties props, String name, String title) {
        return new Form(props, name, name, null);
    }

    @Override
    protected I18nMessages createI18nMessageFormater() {
        return GlobalI18N.getI18nMessageProvider().getI18nMessages(this.properties.getClass());
    }

    public Collection<Widget> getWidgets() {
        return this.widgetMap.values();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Form setName(String name) {
        this.name = name;
        return this;
    }

    public Form setDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public Form setTitle(String title) {
        this.title = title;
        return this;
    }

    public Form setSubtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public String getSubtitle() {
        return this.subtitle != null ? this.subtitle : this.getI18nMessage(I18N_FORM_PREFIX + this.name + I18N_SUBTITLE_NAME_SUFFIX, new Object[0]);
    }

    public Form addRow(NamedThing child) {
        this.addRow(Widget.widget(child));
        return this;
    }

    public Form addColumn(NamedThing child) {
        this.addColumn(Widget.widget(child));
        return this;
    }

    public Form addRow(Widget widget) {
        this.lastColumn = 1;
        String widgetName = this.getWidgetContentName(widget);
        this.widgetMap.put(widgetName, widget.setRow(++this.lastRow).setOrder(this.lastColumn));
        PropertiesDynamicMethodHelper.setWidgetLayoutMethods(this.properties, widgetName, widget);
        return this;
    }

    public Form addColumn(Widget widget) {
        String widgetName = this.getWidgetContentName(widget);
        this.widgetMap.put(widgetName, widget.setRow(this.lastRow).setOrder(++this.lastColumn));
        PropertiesDynamicMethodHelper.setWidgetLayoutMethods(this.properties, widgetName, widget);
        return this;
    }

    public void setVisible(boolean visible) {
        for (Widget w : this.getWidgets()) {
            w.setVisible(visible);
        }
    }

    private String getWidgetContentName(Widget widget) {
        NamedThing child = widget.getContent();
        String widgetName = child.getName();
        if (child instanceof Form) {
            widgetName = ((Form)child).getProperties().getName();
        }
        if (widgetName == null) {
            throw new NullPointerException();
        }
        return widgetName;
    }

    public Widget getWidget(String child) {
        return this.widgetMap.get(child);
    }

    public Widget getWidget(Class<?> childClass) {
        for (Widget w : this.widgetMap.values()) {
            NamedThing p = w.getContent();
            if (p instanceof Form) {
                p = ((Form)p).getProperties();
            }
            if (p.getClass() != childClass) continue;
            return w;
        }
        return null;
    }

    public Form getChildForm(String child) {
        Widget w = this.getWidget(child);
        return (Form)w.getContent();
    }

    public void setValue(String property, Object value) {
        if (property.contains(".")) {
            throw new IllegalArgumentException("Cannot setValue on a qualified property: '" + property + "', use the Form associated with the property.");
        }
        NamedThing se = this.getProperties().getProperty(property);
        if (!(se instanceof Property)) {
            throw new IllegalArgumentException("Attempted to set value on " + se + " which is not a Property");
        }
        Property p = (Property)se;
        if (this.cancelable) {
            if (this.originalValues == null) {
                throw new IllegalStateException("Cannot setValue on " + property + " after cancelValues() has been called");
            }
            if (!this.originalValues.containsKey(property)) {
                this.originalValues.put(property, p.getValue());
            }
        }
        p.setValue(value);
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
        this.originalValues = null;
        if (cancelable) {
            this.originalValues = new HashMap<String, Object>();
        }
        for (Widget w : this.widgetMap.values()) {
            NamedThing p = w.getContent();
            if (!(p instanceof Form)) continue;
            ((Form)p).setCancelable(cancelable);
        }
    }

    public void cancelValues() {
        if (this.originalValues == null) {
            return;
        }
        for (String key : this.originalValues.keySet()) {
            ((Property)this.getProperties().getProperty(key)).setValue(this.originalValues.get(key));
        }
        this.originalValues = null;
        for (Widget w : this.widgetMap.values()) {
            NamedThing p = w.getContent();
            if (!(p instanceof Form)) continue;
            ((Form)p).cancelValues();
        }
    }

    public boolean isRefreshUI() {
        return this.refreshUI;
    }

    public void setRefreshUI(boolean refreshUI) {
        this.refreshUI = refreshUI;
    }

    public boolean isCallBeforeFormPresent() {
        return this.callBeforeFormPresent;
    }

    public void setCallBeforeFormPresent(boolean callBeforeFormPresent) {
        this.callBeforeFormPresent = callBeforeFormPresent;
    }

    public boolean isCallAfterFormBack() {
        return this.callAfterFormBack;
    }

    public void setCallAfterFormBack(boolean callAfterFormBack) {
        this.callAfterFormBack = callAfterFormBack;
    }

    public boolean isCallAfterFormNext() {
        return this.callAfterFormNext;
    }

    public void setCallAfterFormNext(boolean callAfterFormNext) {
        this.callAfterFormNext = callAfterFormNext;
    }

    public boolean isCallAfterFormFinish() {
        return this.callAfterFormFinish;
    }

    public void setCallAfterFormFinish(boolean callAfterFormFinish) {
        this.callAfterFormFinish = callAfterFormFinish;
    }

    public boolean isAllowBack() {
        return this.allowBack;
    }

    public void setAllowBack(boolean allowBack) {
        this.allowBack = allowBack;
    }

    public boolean isAllowForward() {
        return this.allowForward;
    }

    public void setAllowForward(boolean allowForward) {
        this.allowForward = allowForward;
    }

    public boolean isAllowFinish() {
        return this.allowFinish;
    }

    public void setAllowFinish(boolean allowFinish) {
        this.allowFinish = allowFinish;
    }

    @Override
    public String getTitle() {
        return this.title != null ? this.title : this.getI18nMessage(I18N_FORM_PREFIX + this.name + ".title", new Object[0]);
    }

    @Override
    public String getDisplayName() {
        return this.displayName != null ? this.displayName : this.getI18nMessage(I18N_FORM_PREFIX + this.name + ".displayName", new Object[0]);
    }

    @Override
    public String toString() {
        return this.toStringIndent(0);
    }

    @Override
    public String toStringIndent(int indent) {
        StringBuilder sb = new StringBuilder();
        String is = ToStringIndentUtil.indentString(indent);
        sb.append(is + "Form: " + this.getName());
        if (this.isRefreshUI()) {
            sb.append(" REFRESH_UI");
        }
        if (this.isCallBeforeFormPresent()) {
            sb.append(" BEFORE_FORM_PRESENT");
        }
        if (this.isCallAfterFormBack()) {
            sb.append(" AFTER_FORM_BACK");
        }
        if (this.isCallAfterFormNext()) {
            sb.append(" AFTER_FORM_NEXT");
        }
        if (this.isCallAfterFormFinish()) {
            sb.append(" AFTER_FORM_FINISH");
        }
        if (this.isAllowBack()) {
            sb.append(" ALLOW_BACK");
        }
        if (this.isAllowForward()) {
            sb.append(" ALLOW_FORWARD");
        }
        if (this.isAllowFinish()) {
            sb.append(" ALLOW_FINISH");
        }
        for (Widget w : this.getWidgets()) {
            sb.append("\n" + w.toStringIndent(indent + 4));
        }
        return sb.toString();
    }
}

