/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.presentation;

import java.util.List;
import org.talend.daikon.NamedThing;
import org.talend.daikon.properties.Property;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.strings.ToStringIndent;
import org.talend.daikon.strings.ToStringIndentUtil;

public class Widget
implements ToStringIndent {
    private int row;
    private int order;
    private boolean visible = true;
    private WidgetType widgetType = WidgetType.DEFAULT;
    private boolean longRunning;
    private boolean deemphasize;
    private boolean callBeforeActivate;
    private boolean callBeforePresent;
    private boolean callValidate;
    private boolean callAfter;
    private NamedThing content;

    public static Widget widget(NamedThing content) {
        return new Widget(content);
    }

    public Widget(NamedThing content) {
        this.content = content;
    }

    public NamedThing getContent() {
        return this.content;
    }

    public int getRow() {
        return this.row;
    }

    public Widget setRow(int row) {
        this.row = row;
        return this;
    }

    public int getOrder() {
        return this.order;
    }

    public Widget setOrder(int order) {
        this.order = order;
        return this;
    }

    public Widget setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public WidgetType getWidgetType() {
        return this.widgetType;
    }

    public Widget setWidgetType(WidgetType widgetType) {
        this.widgetType = widgetType;
        return this;
    }

    public boolean isLongRunning() {
        return this.longRunning;
    }

    public Widget setLongRunning(boolean longRunning) {
        this.longRunning = longRunning;
        return this;
    }

    public boolean isDeemphasize() {
        return this.deemphasize;
    }

    public Widget setDeemphasize(boolean deemphasize) {
        this.deemphasize = deemphasize;
        return this;
    }

    public boolean isCallBeforeActivate() {
        return this.callBeforeActivate;
    }

    public void setCallBefore(boolean callBefore) {
        if (this.widgetType == WidgetType.SCHEMA_REFERENCE || this.widgetType == WidgetType.NAME_SELECTION_REFERENCE) {
            this.callBeforeActivate = callBefore;
            this.callBeforePresent = !callBefore;
        } else {
            this.callBeforePresent = callBefore;
            this.callBeforeActivate = !callBefore;
        }
    }

    public boolean isCallBeforePresent() {
        return this.callBeforePresent;
    }

    public boolean isCallValidate() {
        return this.callValidate;
    }

    public void setCallValidate(boolean callValidate) {
        this.callValidate = callValidate;
    }

    public boolean isCallAfter() {
        return this.callAfter;
    }

    public void setCallAfter(boolean callAfter) {
        this.callAfter = callAfter;
    }

    public String toString() {
        return this.toStringIndent(0);
    }

    @Override
    public String toStringIndent(int indent) {
        List<?> values;
        StringBuilder sb = new StringBuilder();
        String is = ToStringIndentUtil.indentString(indent);
        sb.append(is + "Widget: " + (Object)((Object)this.getWidgetType()) + " " + this.getRow() + "/" + this.getOrder() + " ");
        NamedThing n = this.getContent();
        if (n instanceof Form) {
            sb.append("Form: ");
        }
        sb.append(n.getName());
        if (n instanceof Form) {
            sb.append(" (props: " + ((Form)n).getProperties().getName() + ")");
        }
        if (n instanceof Property && (values = ((Property)n).getPossibleValues()) != null) {
            sb.append(" Values: " + values);
        }
        if (this.isCallBeforeActivate()) {
            sb.append(" CALL_BEFORE_ACTIVATE");
        }
        if (this.isCallBeforePresent()) {
            sb.append(" CALL_BEFORE_PRESENT");
        }
        if (this.isCallAfter()) {
            sb.append(" CALL_AFTER");
        }
        if (this.isCallValidate()) {
            sb.append(" CALL_VALIDATE");
        }
        return sb.toString();
    }

    public static enum WidgetType {
        DEFAULT,
        SCHEMA_EDITOR,
        SCHEMA_REFERENCE,
        NAME_SELECTION_AREA,
        NAME_SELECTION_REFERENCE,
        COMPONENT_REFERENCE,
        BUTTON,
        TABLE,
        HIDDEN_TEXT;

    }
}

