/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.properties.service;

import org.talend.daikon.properties.Properties;
import org.talend.daikon.properties.PropertiesDynamicMethodHelper;
import org.talend.daikon.properties.presentation.Form;
import org.talend.daikon.properties.service.PropertiesService;
import org.talend.daikon.properties.service.Repository;

public class PropertiesServiceImpl<T extends Properties>
implements PropertiesService<T> {
    private Repository<T> repository;

    @Override
    public T makeFormCancelable(T properties, String formName) {
        Form form = ((Properties)properties).getForm(formName);
        if (form == null) {
            throw new IllegalArgumentException("Form: " + formName + " not found");
        }
        form.setCancelable(true);
        return properties;
    }

    @Override
    public T cancelFormValues(T properties, String formName) {
        Form form = ((Properties)properties).getForm(formName);
        if (form == null) {
            throw new IllegalArgumentException("Form: " + formName + " not found");
        }
        form.cancelValues();
        return properties;
    }

    @Override
    public T validateProperty(String propName, T properties) throws Throwable {
        PropertiesDynamicMethodHelper.validateProperty(properties, propName);
        return properties;
    }

    @Override
    public T beforePropertyActivate(String propName, T properties) throws Throwable {
        PropertiesDynamicMethodHelper.beforePropertyActivate(properties, propName);
        return properties;
    }

    @Override
    public T beforePropertyPresent(String propName, T properties) throws Throwable {
        PropertiesDynamicMethodHelper.beforePropertyPresent(properties, propName);
        return properties;
    }

    @Override
    public T afterProperty(String propName, T properties) throws Throwable {
        PropertiesDynamicMethodHelper.afterProperty(properties, propName);
        return properties;
    }

    @Override
    public T beforeFormPresent(String formName, T properties) throws Throwable {
        PropertiesDynamicMethodHelper.beforeFormPresent(properties, formName);
        return properties;
    }

    @Override
    public T afterFormNext(String formName, T properties) throws Throwable {
        PropertiesDynamicMethodHelper.afterFormNext(properties, formName);
        return properties;
    }

    @Override
    public T afterFormBack(String formName, T properties) throws Throwable {
        PropertiesDynamicMethodHelper.afterFormBack(properties, formName);
        return properties;
    }

    @Override
    public T afterFormFinish(String formName, T properties) throws Throwable {
        PropertiesDynamicMethodHelper.afterFormFinish(properties, formName, this.repository);
        return properties;
    }

    @Override
    public String storeProperties(T properties, String name, String repositoryLocation, String schemaPropertyName) {
        if (this.repository != null) {
            return this.repository.storeProperties(properties, name, repositoryLocation, schemaPropertyName);
        }
        return null;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }
}

