/*
 * Decompiled with CFR 0.152.
 */
package org.talend.daikon.talend6;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.talend.daikon.avro.IndexedRecordAdapterFactory;
import org.talend.daikon.avro.util.AvroUtils;
import org.talend.daikon.avro.util.SingleColumnIndexedRecordAdapterFactory;
import org.talend.daikon.talend6.Talend6SchemaConstants;

public class Talend6OutgoingSchemaEnforcer
implements IndexedRecord,
Talend6SchemaConstants {
    private boolean byIndex;
    private final Schema outgoing;
    private IndexedRecord wrapped;
    private final int outgoingDynamicColumn;
    private Schema outgoingDynamicRuntimeSchema;
    private Map<String, Integer> dynamicColumnSources;

    public Talend6OutgoingSchemaEnforcer(Schema outgoing, boolean byIndex) {
        this.outgoing = outgoing;
        this.byIndex = byIndex;
        this.outgoingDynamicColumn = AvroUtils.isIncludeAllFields(outgoing) ? Integer.valueOf(outgoing.getProp("talend6.dynamic.column.position")) : -1;
    }

    public void setWrapped(IndexedRecord wrapped) {
        if (wrapped instanceof SingleColumnIndexedRecordAdapterFactory.PrimitiveAsIndexedRecordAdapter) {
            this.byIndex = true;
        }
        this.wrapped = wrapped;
        if (this.outgoingDynamicRuntimeSchema == null && this.outgoingDynamicColumn != -1) {
            List<Schema.Field> copyFieldList = null;
            copyFieldList = this.byIndex ? this.getDynamicSchemaByIndex() : this.getDynamicSchemaByName();
            this.outgoingDynamicRuntimeSchema = Schema.createRecord((String)"dynamic", null, null, (boolean)false);
            this.outgoingDynamicRuntimeSchema.setFields(copyFieldList);
        }
    }

    public Schema getSchema() {
        return this.outgoing;
    }

    public Schema getOutgoingDynamicRuntimeSchema() {
        return this.outgoingDynamicRuntimeSchema;
    }

    public void put(int i, Object v) {
        throw new IndexedRecordAdapterFactory.UnmodifiableAdapterException();
    }

    public Object get(int i) {
        int wrappedIndex;
        if (this.outgoingDynamicColumn != -1) {
            if (i == this.outgoingDynamicColumn) {
                if (this.byIndex) {
                    return this.getDynamicMapByIndex();
                }
                return this.getDynamicMapByName();
            }
            if (i > this.outgoingDynamicColumn) {
                --i;
            }
        }
        if (i >= this.outgoing.getFields().size()) {
            throw new ArrayIndexOutOfBoundsException(i);
        }
        Schema.Field outField = (Schema.Field)this.getSchema().getFields().get(i);
        Schema.Field wrappedField = null;
        if (this.byIndex) {
            wrappedIndex = this.outgoingDynamicColumn != -1 && i >= this.outgoingDynamicColumn ? this.getNumberOfDynamicColumns() + i : i;
            if (wrappedIndex >= this.wrapped.getSchema().getFields().size()) {
                return this.transformValue(null, null, outField);
            }
            wrappedField = (Schema.Field)this.wrapped.getSchema().getFields().get(wrappedIndex);
        } else {
            wrappedField = this.wrapped.getSchema().getField(outField.name());
            if (wrappedField == null) {
                return this.transformValue(null, null, outField);
            }
            wrappedIndex = wrappedField.pos();
        }
        Object value = this.wrapped.get(wrappedIndex);
        return this.transformValue(value, wrappedField, outField);
    }

    private Object transformValue(Object value, Schema.Field wrappedField, Schema.Field outField) {
        String talendType = outField.getProp("talend6.column.talendType");
        if (null == talendType || null == value) {
            return value;
        }
        if ("id_Short".equals(talendType)) {
            return value instanceof Number ? ((Number)value).shortValue() : Short.parseShort(String.valueOf(value));
        }
        if ("id_Date".equals(talendType)) {
            return new Date((Long)value);
        }
        if ("id_Byte".equals(talendType)) {
            return value instanceof Number ? ((Number)value).byteValue() : Byte.parseByte(String.valueOf(value));
        }
        return value;
    }

    private int getNumberOfDynamicColumns() {
        int dynColN = this.wrapped.getSchema().getFields().size() - this.getSchema().getFields().size();
        if (dynColN < 0) {
            throw new UnsupportedOperationException("The incoming data does not have sufficient columns to create a dynamic column.");
        }
        return dynColN;
    }

    private Map<String, Object> getDynamicMapByIndex() {
        int dynColN = this.getNumberOfDynamicColumns();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (int j = 0; j < dynColN; ++j) {
            result.put(((Schema.Field)this.wrapped.getSchema().getFields().get(this.outgoingDynamicColumn + j)).name(), this.wrapped.get(this.outgoingDynamicColumn + j));
        }
        return result;
    }

    private List<Schema.Field> getDynamicSchemaByIndex() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        int dynColN = this.getNumberOfDynamicColumns();
        for (int j = 0; j < dynColN; ++j) {
            Schema.Field se = (Schema.Field)this.wrapped.getSchema().getFields().get(this.outgoingDynamicColumn + j);
            fields.add(new Schema.Field(se.name(), se.schema(), se.doc(), se.defaultVal()));
        }
        return fields;
    }

    private Map<String, Object> getDynamicMapByName() {
        if (this.dynamicColumnSources == null) {
            this.dynamicColumnSources = new HashMap<String, Integer>();
            for (Schema.Field wrappedField : this.wrapped.getSchema().getFields()) {
                Schema.Field outField = this.getSchema().getField(wrappedField.name());
                if (outField != null) continue;
                this.dynamicColumnSources.put(wrappedField.name(), wrappedField.pos());
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Integer> e : this.dynamicColumnSources.entrySet()) {
            result.put(e.getKey(), this.wrapped.get(e.getValue().intValue()));
        }
        return result;
    }

    private List<Schema.Field> getDynamicSchemaByName() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        ArrayList<String> designColumnsName = new ArrayList<String>();
        for (Schema.Field se : this.outgoing.getFields()) {
            designColumnsName.add(se.name());
        }
        Schema runtimeSchema = this.wrapped.getSchema();
        for (Schema.Field se : runtimeSchema.getFields()) {
            if (designColumnsName.contains(se.name())) continue;
            fields.add(new Schema.Field(se.name(), se.schema(), se.doc(), se.defaultVal()));
        }
        return fields;
    }
}

