/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.mapping.datastore;

import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.exceptions.NullValueException;
import org.datanucleus.store.rdbms.mapping.datastore.AbstractDatastoreMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.SingleFieldMapping;
import org.datanucleus.store.rdbms.schema.SQLTypeInfo;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.util.StringUtils;

public class SmallIntRDBMSMapping
extends AbstractDatastoreMapping {
    protected SmallIntRDBMSMapping(RDBMSStoreManager storeMgr, JavaTypeMapping mapping) {
        super(storeMgr, mapping);
    }

    public SmallIntRDBMSMapping(JavaTypeMapping mapping, RDBMSStoreManager storeMgr, Column col) {
        super(storeMgr, mapping);
        this.column = col;
        this.initialize();
    }

    private void initialize() {
        if (this.column != null) {
            Object[] validValues;
            this.column.checkPrimitive();
            JavaTypeMapping m = this.getJavaTypeMapping();
            if (m instanceof SingleFieldMapping && (validValues = ((SingleFieldMapping)m).getValidValues(0)) != null) {
                String constraints = this.storeMgr.getDatastoreAdapter().getCheckConstraintForValues(this.column.getIdentifier(), validValues, this.column.isNullable());
                this.column.setConstraints(constraints);
            }
            if (this.getJavaTypeMapping().getJavaType() == Boolean.class) {
                StringBuffer constraints = new StringBuffer("CHECK (" + this.column.getIdentifier() + " IN (0,1)");
                if (this.column.isNullable()) {
                    constraints.append(" OR " + this.column.getIdentifier() + " IS NULL");
                }
                constraints.append(')');
                this.column.setConstraints(constraints.toString());
            }
        }
        this.initTypeInfo();
    }

    @Override
    public boolean isIntegerBased() {
        return true;
    }

    @Override
    public SQLTypeInfo getTypeInfo() {
        if (this.column != null && this.column.getColumnMetaData().getSqlType() != null) {
            return this.storeMgr.getSQLTypeInfoForJDBCType(5, this.column.getColumnMetaData().getSqlType());
        }
        return this.storeMgr.getSQLTypeInfoForJDBCType(5);
    }

    @Override
    public void setBoolean(PreparedStatement ps, int param, boolean value) {
        try {
            ps.setInt(param, value ? 1 : 0);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"boolean", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public boolean getBoolean(ResultSet rs, int param) {
        boolean value;
        try {
            int intValue = rs.getInt(param);
            if (intValue == 0) {
                value = false;
            } else if (intValue == 1) {
                value = true;
            } else {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055006", (Object)"Types.SMALLINT", (Object)("" + intValue)));
            }
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Boolean", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setShort(PreparedStatement ps, int param, short value) {
        try {
            ps.setShort(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"short", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public short getShort(ResultSet rs, int param) {
        short value;
        try {
            value = rs.getShort(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"short", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setInt(PreparedStatement ps, int param, int value) {
        try {
            ps.setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"int", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public int getInt(ResultSet rs, int param) {
        int value;
        try {
            value = rs.getInt(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"int", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setLong(PreparedStatement ps, int param, long value) {
        try {
            ps.setLong(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"short", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public long getLong(ResultSet rs, int param) {
        long value;
        try {
            value = rs.getShort(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"short", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setByte(PreparedStatement ps, int param, byte value) {
        try {
            ps.setInt(param, value);
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"byte", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public byte getByte(ResultSet rs, int param) {
        byte value;
        try {
            value = rs.getByte(param);
            if ((this.column == null || this.column.getColumnMetaData() == null || !this.column.getColumnMetaData().isAllowsNull()) && rs.wasNull()) {
                throw new NullValueException(LOCALISER_RDBMS.msg("055003", (Object)this.column));
            }
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"byte", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }

    @Override
    public void setObject(PreparedStatement ps, int param, Object value) {
        block12: {
            try {
                if (value == null) {
                    if (this.column != null && this.column.isDefaultable() && this.column.getDefaultValue() != null && !StringUtils.isWhitespace((String)this.column.getDefaultValue().toString())) {
                        ps.setInt(param, Integer.valueOf(this.column.getDefaultValue().toString()));
                    } else {
                        ps.setNull(param, this.getTypeInfo().getDataType());
                    }
                    break block12;
                }
                Class<?> type = value.getClass();
                if (type == Integer.class) {
                    ps.setShort(param, ((Integer)value).shortValue());
                    break block12;
                }
                if (type == Short.class) {
                    ps.setShort(param, (Short)value);
                    break block12;
                }
                if (type == Byte.class) {
                    ps.setShort(param, ((Byte)value).shortValue());
                    break block12;
                }
                if (type == Character.class) {
                    ps.setShort(param, (short)((Character)value).charValue());
                    break block12;
                }
                if (type == Boolean.class) {
                    ps.setShort(param, (short)((Boolean)value != false ? 1 : 0));
                    break block12;
                }
                if (type == BigInteger.class) {
                    ps.setShort(param, ((BigInteger)value).shortValue());
                    break block12;
                }
                if (type == Long.class) {
                    ps.setShort(param, ((Long)value).shortValue());
                    break block12;
                }
                throw new NucleusException("SmallIntRDBMSMapping.setObject called for " + StringUtils.toJVMIDString((Object)value) + " but not supported");
            }
            catch (SQLException e) {
                throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055001", (Object)"Object", (Object)("" + value), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public Object getObject(ResultSet rs, int param) {
        Comparable<Short> value;
        try {
            short d = rs.getShort(param);
            Class type = this.getJavaTypeMapping().getJavaType();
            value = type == Short.class ? (rs.wasNull() ? null : Short.valueOf(d)) : (type == Integer.class ? (rs.wasNull() ? null : Integer.valueOf(d)) : (type == Byte.class ? (rs.wasNull() ? null : Byte.valueOf((byte)d)) : (type == BigInteger.class ? (rs.wasNull() ? null : BigInteger.valueOf(d)) : (type == Boolean.class ? (Comparable<Boolean>)(rs.wasNull() ? null : (d == 1 ? Boolean.TRUE : Boolean.FALSE)) : (Comparable<Boolean>)(rs.wasNull() ? null : Short.valueOf(d))))));
        }
        catch (SQLException e) {
            throw new NucleusDataStoreException(LOCALISER_RDBMS.msg("055002", (Object)"Object", (Object)("" + param), (Object)this.column, (Object)e.getMessage()), (Throwable)e);
        }
        return value;
    }
}

