/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.transformation.pipeline.ActionRegistry;

public class ClassPathActionRegistry
implements ActionRegistry {
    private static final Object lock = new Object();
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassPathActionRegistry.class);
    private final Map<String, Class<? extends ActionDefinition>> nameToActionClass = new TreeMap<String, Class<? extends ActionDefinition>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPathActionRegistry(String ... actionPackages) {
        Object object = lock;
        synchronized (object) {
            for (String actionPackage : actionPackages) {
                LOGGER.info("Scanning classpath @ '{}'", (Object)actionPackage);
                Reflections reflections = new Reflections(actionPackage, new Scanner[0]);
                Set allActions = reflections.getSubTypesOf(ActionDefinition.class);
                LOGGER.info("Found {} possible action class(es) in '{}'", (Object)allActions.size(), (Object)actionPackage);
                block6: for (Class action : allActions) {
                    try {
                        if (!Modifier.isAbstract(action.getModifiers())) {
                            Constructor<?>[] constructors;
                            for (Constructor<?> constructor : constructors = action.getConstructors()) {
                                if (constructor.getParameters().length != 0) continue;
                                ActionDefinition actionMetadata = (ActionDefinition)action.newInstance();
                                this.nameToActionClass.put(actionMetadata.getName(), action);
                                continue block6;
                            }
                            continue;
                        }
                        LOGGER.info("Skip class '{}' (abstract class).", (Object)action.getName());
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to register action '{}'", (Object)action.getName(), (Object)e);
                    }
                }
            }
        }
        LOGGER.info("{} actions registered for usage.", (Object)this.nameToActionClass.size());
    }

    public ActionDefinition get(String name) {
        try {
            Class<? extends ActionDefinition> aClass = this.nameToActionClass.get(name);
            if (aClass == null) {
                LOGGER.error("Action definition '{}' does not exist.", (Object)name);
                return null;
            }
            return aClass.newInstance();
        }
        catch (Exception e) {
            LOGGER.error("Unable to return action definition '{}'", (Object)name, (Object)e);
            return null;
        }
    }

    public Stream<Class<? extends ActionDefinition>> getAll() {
        return this.nameToActionClass.values().stream();
    }
}

