/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.bool;

import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.WordUtils;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#negate")
public class Negate
extends AbstractActionMetadata
implements ColumnAction {
    static final String NEGATE_ACTION_NAME = "negate";

    @Override
    public String getName() {
        return NEGATE_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.BOOLEAN.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.BOOLEAN.equals((Object)Type.get((String)column.getType()));
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String value = row.get(columnId);
        if (this.isBoolean(value)) {
            Boolean boolValue = Boolean.valueOf(value);
            row.set(columnId, WordUtils.capitalizeFully((String)("" + (boolValue == false))));
        }
    }

    private boolean isBoolean(String value) {
        return value != null && ("true".equalsIgnoreCase(value.trim()) || "false".equalsIgnoreCase(value.trim()));
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

