/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.clear;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.category.ActionScope;
import org.talend.dataprep.transformation.actions.clear.AbstractClear;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#clear_invalid")
public class ClearInvalid
extends AbstractClear
implements ColumnAction {
    public static final String ACTION_NAME = "clear_invalid";
    private static final List<String> ACTION_SCOPE = Collections.singletonList(ActionScope.INVALID.getDisplayName());

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATA_CLEANSING.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public List<String> getActionScope() {
        return ACTION_SCOPE;
    }

    @Override
    public boolean toClear(DataSetRow dataSetRow, String columnId, ActionContext actionContext) {
        return dataSetRow.isInvalid(columnId);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        EnumSet<ActionDefinition.Behavior> behaviors = EnumSet.copyOf(super.getBehavior());
        behaviors.add(ActionDefinition.Behavior.NEED_STATISTICS_INVALID);
        return behaviors;
    }
}

