/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.clear;

import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.clear.AbstractClear;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.ReplaceOnValueHelper;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#clear_matching")
public class ClearMatching
extends AbstractClear
implements ColumnAction {
    public static final String ACTION_NAME = "clear_matching";
    public static final String VALUE_PARAMETER = "matching_value";
    private final Type type;
    private ReplaceOnValueHelper regexParametersHelper = new ReplaceOnValueHelper();

    public ClearMatching() {
        this(Type.STRING);
    }

    public ClearMatching(Type type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATA_CLEANSING.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        if (this.type == Type.BOOLEAN) {
            parameters.add((Parameter)SelectParameter.Builder.builder().name(VALUE_PARAMETER).item(Boolean.TRUE.toString()).item(Boolean.FALSE.toString()).build());
        } else {
            parameters.add(new Parameter(VALUE_PARAMETER, ParameterType.REGEX, "", false, false, ""));
        }
        return parameters;
    }

    @Override
    public ActionDefinition adapt(Schema.Field field) {
        if (field == null || !this.acceptField(field)) {
            return this;
        }
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return new ClearMatching(Type.valueOf((String)column.getType().toUpperCase()));
    }

    @Override
    public boolean toClear(DataSetRow dataSetRow, String columnId, ActionContext actionContext) {
        Map parameters = actionContext.getParameters();
        RowMetadata rowMetadata = actionContext.getRowMetadata();
        ColumnMetadata columnMetadata = rowMetadata.getById(columnId);
        String value = dataSetRow.get(columnId);
        String equalsValue = (String)parameters.get(VALUE_PARAMETER);
        if (Type.get((String)columnMetadata.getType()) == Type.BOOLEAN) {
            return StringUtils.equalsIgnoreCase((String)value, (String)equalsValue);
        }
        ReplaceOnValueHelper replaceOnValueHelper = this.regexParametersHelper.build(equalsValue, true);
        return replaceOnValueHelper.matches(value);
    }
}

