/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.exception.error.ActionErrorCodes;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.OtherColumnParameters;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#concat")
public class Concat
extends AbstractActionMetadata
implements ColumnAction,
OtherColumnParameters {
    public static final String CONCAT_ACTION_NAME = "concat";
    public static final String PREFIX_PARAMETER = "prefix";
    public static final String SEPARATOR_PARAMETER = "concat_separator";
    public static final String SUFFIX_PARAMETER = "suffix";
    public static final String COLUMN_NAMES_SEPARATOR = "_";
    public static final String CONCAT_NEW_COLUMN = "new_column";
    public static final String SEPARATOR_CONDITION = "concat_separator_condition";
    public static final String BOTH_NOT_EMPTY = "concat_both_not_empty";
    public static final String ALWAYS = "concat_always";

    @Override
    public String getName() {
        return CONCAT_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMNS.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(PREFIX_PARAMETER, ParameterType.STRING, ""));
        parameters.add((Parameter)SelectParameter.Builder.builder().name("mode").item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, "", false, false, ""), new Parameter(SEPARATOR_PARAMETER, ParameterType.STRING, ""), SelectParameter.Builder.builder().name(SEPARATOR_CONDITION).item(BOTH_NOT_EMPTY).item(ALWAYS).defaultValue(BOTH_NOT_EMPTY).build()}).item("constant_mode").defaultValue("other_column_mode").build());
        parameters.add(new Parameter(SUFFIX_PARAMETER, ParameterType.STRING, ""));
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            this.checkSelectedColumnParameter(context.getParameters(), context.getRowMetadata());
            RowMetadata rowMetadata = context.getRowMetadata();
            String columnId = context.getColumnId();
            Map parameters = context.getParameters();
            ColumnMetadata sourceColumn = rowMetadata.getById(columnId);
            String newColumnName = this.evalNewColumnName(sourceColumn.getName(), rowMetadata, parameters);
            context.column(CONCAT_NEW_COLUMN, r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(newColumnName).type(Type.STRING).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
            context.setActionStatus(ActionContext.ActionStatus.OK);
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        RowMetadata rowMetadata = context.getRowMetadata();
        String columnId = context.getColumnId();
        Map parameters = context.getParameters();
        String concatColumn = context.column(CONCAT_NEW_COLUMN);
        String separatorCondition = (String)parameters.get(SEPARATOR_CONDITION);
        String sourceValue = row.get(columnId);
        StringBuilder newValue = new StringBuilder(64);
        newValue.append(this.getParameter(parameters, PREFIX_PARAMETER, ""));
        newValue.append(StringUtils.isBlank((String)sourceValue) ? "" : sourceValue);
        if (((String)parameters.get("mode")).equals("other_column_mode")) {
            boolean addSeparator;
            ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get("selected_column"));
            String selectedColumnValue = row.get(selectedColumn.getId());
            boolean bl = addSeparator = StringUtils.equals((String)separatorCondition, (String)ALWAYS) || (StringUtils.equals((String)separatorCondition, (String)BOTH_NOT_EMPTY) || StringUtils.isBlank((String)separatorCondition)) && StringUtils.isNotBlank((String)sourceValue) && StringUtils.isNotBlank((String)selectedColumnValue);
            if (addSeparator) {
                newValue.append(this.getParameter(parameters, SEPARATOR_PARAMETER, ""));
            }
            if (StringUtils.isNotBlank((String)selectedColumnValue)) {
                newValue.append(selectedColumnValue);
            }
        }
        newValue.append(this.getParameter(parameters, SUFFIX_PARAMETER, ""));
        row.set(concatColumn, newValue.toString());
    }

    private String evalNewColumnName(String sourceColumnName, RowMetadata rowMetadata, Map<String, String> parameters) {
        String prefix = this.getParameter(parameters, PREFIX_PARAMETER, "");
        String suffix = this.getParameter(parameters, SUFFIX_PARAMETER, "");
        if (parameters.get("mode").equals("other_column_mode")) {
            ColumnMetadata selectedColumn = rowMetadata.getById(parameters.get("selected_column"));
            return sourceColumnName + COLUMN_NAMES_SEPARATOR + selectedColumn.getName();
        }
        return prefix + sourceColumnName + suffix;
    }

    private void checkSelectedColumnParameter(Map<String, String> parameters, RowMetadata rowMetadata) {
        if (parameters.get("mode").equals("other_column_mode") && (!parameters.containsKey("selected_column") || rowMetadata.getById(parameters.get("selected_column")) == null)) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)"selected_column"));
        }
    }

    private String getParameter(Map<String, String> parameters, String parameterName, String defaultValue) {
        String value = parameters.get(parameterName);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

