/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.category.ActionScope;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#copy")
public class CopyColumnMetadata
extends AbstractActionMetadata
implements ColumnAction {
    public static final String COPY_ACTION_NAME = "copy";
    public static final String COPY_APPENDIX = "_copy";
    private static final String TARGET_COLUMN_ID_KEY = "TARGET_COLUMN_ID_KEY";

    @Override
    public String getName() {
        return COPY_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMN_METADATA.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public List<String> getActionScope() {
        return Collections.singletonList(ActionScope.COLUMN_METADATA.getDisplayName());
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            RowMetadata rowMetadata = actionContext.getRowMetadata();
            String columnId = actionContext.getColumnId();
            ColumnMetadata column = rowMetadata.getById(columnId);
            String copyColumnId = actionContext.column(column.getName() + COPY_APPENDIX, r -> {
                ColumnMetadata newColumn = ColumnMetadata.Builder.column().copy(column).computedId("").name(column.getName() + COPY_APPENDIX).build();
                rowMetadata.insertAfter(columnId, newColumn);
                return newColumn;
            });
            actionContext.get(TARGET_COLUMN_ID_KEY, m -> copyColumnId);
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String copyColumn = (String)context.get(TARGET_COLUMN_ID_KEY);
        String columnId = context.getColumnId();
        row.set(copyColumn, row.get(columnId));
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_COPY_COLUMNS);
    }
}

