/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.exception.error.ActionErrorCodes;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.category.ActionScope;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#create_new_column")
public class CreateNewColumn
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ACTION_NAME = "create_new_column";
    public static final String DEFAULT_VALUE_PARAMETER = "default_value";
    public static final String MODE_PARAMETER = "mode_new_column";
    public static final String SELECTED_COLUMN_PARAMETER = "selected_column";
    public static final String EMPTY_MODE = "Nothing, this column will be empty";
    public static final String CONSTANT_MODE = "A constant";
    public static final String COLUMN_MODE = "Another column";
    public static final String NEW_COLUMN = "new_column";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMN_METADATA.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public List<String> getActionScope() {
        return Collections.singletonList(ActionScope.COLUMN_METADATA.getDisplayName());
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        Parameter constantParameter = new Parameter(DEFAULT_VALUE_PARAMETER, ParameterType.STRING, "");
        parameters.add((Parameter)SelectParameter.Builder.builder().name(MODE_PARAMETER).item(EMPTY_MODE).item(CONSTANT_MODE, new Parameter[]{constantParameter}).item(COLUMN_MODE, new Parameter[]{new Parameter(SELECTED_COLUMN_PARAMETER, ParameterType.COLUMN, "", false, false, "")}).defaultValue(COLUMN_MODE).build());
        return parameters;
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            this.checkParameters(context.getParameters(), context.getRowMetadata());
            RowMetadata rowMetadata = context.getRowMetadata();
            String columnId = context.getColumnId();
            Map parameters = context.getParameters();
            context.column(NEW_COLUMN, r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(this.evalNewColumnName(rowMetadata, parameters)).type(Type.STRING).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        RowMetadata rowMetadata = context.getRowMetadata();
        Map parameters = context.getParameters();
        String newColumn = context.column(NEW_COLUMN);
        String newValue = "";
        switch ((String)parameters.get(MODE_PARAMETER)) {
            case "Nothing, this column will be empty": {
                newValue = "";
                break;
            }
            case "A constant": {
                newValue = (String)parameters.get(DEFAULT_VALUE_PARAMETER);
                break;
            }
            case "Another column": {
                ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get(SELECTED_COLUMN_PARAMETER));
                newValue = row.get(selectedColumn.getId());
                break;
            }
        }
        row.set(newColumn, newValue);
    }

    private String evalNewColumnName(RowMetadata rowMetadata, Map<String, String> parameters) {
        if (parameters.get(MODE_PARAMETER).equals(COLUMN_MODE)) {
            ColumnMetadata selectedColumn = rowMetadata.getById(parameters.get(SELECTED_COLUMN_PARAMETER));
            return selectedColumn.getName() + "_copy";
        }
        return "new column";
    }

    private void checkParameters(Map<String, String> parameters, RowMetadata rowMetadata) {
        if (!parameters.containsKey(MODE_PARAMETER)) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)MODE_PARAMETER));
        }
        if (parameters.get(MODE_PARAMETER).equals(CONSTANT_MODE) && !parameters.containsKey(DEFAULT_VALUE_PARAMETER)) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)DEFAULT_VALUE_PARAMETER));
        }
        if (parameters.get(MODE_PARAMETER).equals(COLUMN_MODE) && (!parameters.containsKey(SELECTED_COLUMN_PARAMETER) || rowMetadata.getById(parameters.get(SELECTED_COLUMN_PARAMETER)) == null)) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)SELECTED_COLUMN_PARAMETER));
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

