/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.category.ActionScope;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#delete_column")
public class DeleteColumn
extends AbstractActionMetadata
implements ColumnAction {
    public static final String DELETE_COLUMN_ACTION_NAME = "delete_column";
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteColumn.class);

    @Override
    public String getName() {
        return DELETE_COLUMN_ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMN_METADATA.getDisplayName();
    }

    @Override
    public List<String> getActionScope() {
        return Collections.singletonList(ActionScope.COLUMN_METADATA.getDisplayName());
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        LOGGER.debug("DeleteColumn for columnId {}", (Object)columnId);
        context.getRowMetadata().deleteColumnById(columnId);
        row.deleteColumnById(columnId);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_DELETE_COLUMNS);
    }
}

