/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#domain_change")
public class DomainChange
extends AbstractActionMetadata
implements ColumnAction {
    public static final String DOMAIN_CHANGE_ACTION_NAME = "domain_change";
    public static final String NEW_DOMAIN_ID_PARAMETER_KEY = "new_domain_id";
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainChange.class);

    @Override
    public String getName() {
        return DOMAIN_CHANGE_ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMN_METADATA.getDisplayName();
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        Map parameters = context.getParameters();
        LOGGER.debug("DomainChange for columnId {} with parameters {} ", (Object)columnId, (Object)parameters);
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata columnMetadata = rowMetadata.getById(columnId);
        String newDomainId = (String)parameters.get(NEW_DOMAIN_ID_PARAMETER_KEY);
        if (StringUtils.isNotEmpty((String)newDomainId)) {
            columnMetadata.setDomain(newDomainId);
            columnMetadata.setDomainFrequency(0.0f);
            columnMetadata.setDomainForced(true);
        }
        rowMetadata.update(columnId, columnMetadata);
        context.setActionStatus(ActionContext.ActionStatus.DONE);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CHANGE_TYPE);
    }
}

