/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.category.ActionScope;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#rename_column")
public class Rename
extends AbstractActionMetadata
implements ColumnAction {
    public static final String RENAME_ACTION_NAME = "rename_column";
    public static final String NEW_COLUMN_NAME_PARAMETER_NAME = "new_column_name";
    private final List<Parameter> parameters = super.getParameters();

    public Rename() {
        this("");
    }

    public Rename(String defaultName) {
        this.parameters.add(new Parameter(NEW_COLUMN_NAME_PARAMETER_NAME, ParameterType.STRING, defaultName, false, false, ""));
    }

    @Override
    public String getName() {
        return RENAME_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMN_METADATA.getDisplayName();
    }

    @Override
    public List<String> getActionScope() {
        return Collections.singletonList(ActionScope.COLUMN_METADATA.getDisplayName());
    }

    @Override
    @Nonnull
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public ActionDefinition adapt(Schema.Field field) {
        if (field == null) {
            return this;
        }
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return new Rename(column.getName());
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String newColumnName = (String)context.getParameters().get(NEW_COLUMN_NAME_PARAMETER_NAME);
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata column = rowMetadata.getById(context.getColumnId());
        column.setName(newColumnName);
        rowMetadata.update(context.getColumnId(), column);
        context.setActionStatus(ActionContext.ActionStatus.DONE);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CHANGE_NAME);
    }
}

