/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.Quality;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.statistics.Statistics;
import org.talend.dataprep.exception.error.ActionErrorCodes;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.DataSetAction;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#reorder")
public class ReorderColumn
extends AbstractActionMetadata
implements DataSetAction {
    public static final String REORDER_ACTION_NAME = "reorder";
    private static final Logger LOGGER = LoggerFactory.getLogger(ReorderColumn.class);

    @Override
    public String getName() {
        return REORDER_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMNS.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter("selected_column", ParameterType.COLUMN, "", false, false));
        return parameters;
    }

    @Override
    public List<String> getActionScope() {
        return Collections.emptyList();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        Map parameters = actionContext.getParameters();
        RowMetadata rowMetadata = actionContext.getRowMetadata();
        String targetColumnId = (String)parameters.get("selected_column");
        ColumnMetadata targetColumn = rowMetadata.getById(targetColumnId);
        if (targetColumn == null) {
            return;
        }
        String originColumnId = (String)parameters.get(ImplicitParameters.COLUMN_ID.getKey());
        int index = 0;
        int originIndex = 0;
        int targetIndex = 0;
        for (ColumnMetadata columnMetadata : rowMetadata.getColumns()) {
            if (StringUtils.equals((String)columnMetadata.getId(), (String)originColumnId)) {
                originIndex = index;
            }
            if (StringUtils.equals((String)columnMetadata.getId(), (String)targetColumnId)) {
                targetIndex = index;
            }
            ++index;
        }
        boolean forwardMove = targetIndex > originIndex;
        try {
            if (forwardMove) {
                for (index = originIndex; index < targetIndex; ++index) {
                    this.swapColumnMetadata((ColumnMetadata)rowMetadata.getColumns().get(index), (ColumnMetadata)rowMetadata.getColumns().get(index + 1));
                }
            } else {
                for (index = originIndex; index > targetIndex; --index) {
                    this.swapColumnMetadata((ColumnMetadata)rowMetadata.getColumns().get(index), (ColumnMetadata)rowMetadata.getColumns().get(index - 1));
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("cannot swap columns: {}", (Object)e.getMessage());
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.UNEXPECTED_EXCEPTION, ExceptionContext.build().put("message", (Object)e.getMessage()));
        }
    }

    protected void swapColumnMetadata(ColumnMetadata originColumn, ColumnMetadata targetColumn) throws Exception {
        ColumnMetadata targetColumnCopy = ColumnMetadata.Builder.column().copy(targetColumn).build();
        ColumnMetadata originColumnCopy = ColumnMetadata.Builder.column().copy(originColumn).build();
        BeanUtils.copyProperties((Object)targetColumn, (Object)originColumn);
        BeanUtils.copyProperties((Object)originColumn, (Object)targetColumnCopy);
        Statistics originalStatistics = originColumnCopy.getStatistics();
        Statistics targetStatistics = targetColumnCopy.getStatistics();
        BeanUtils.copyProperties((Object)targetColumn.getStatistics(), (Object)originalStatistics);
        BeanUtils.copyProperties((Object)originColumn.getStatistics(), (Object)targetStatistics);
        Quality originalQuality = originColumnCopy.getQuality();
        Quality targetQualityCopty = targetColumnCopy.getQuality();
        BeanUtils.copyProperties((Object)targetColumn.getQuality(), (Object)originalQuality);
        BeanUtils.copyProperties((Object)originColumn.getQuality(), (Object)targetQualityCopty);
    }

    public void applyOnDataSet(DataSetRow row, ActionContext context) {
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

