/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.actions.common.OtherColumnParameters;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#swap_column")
public class Swap
extends AbstractActionMetadata
implements ColumnAction,
OtherColumnParameters {
    public static final String SWAP_COLUMN_ACTION_NAME = "swap_column";
    private static final Logger LOGGER = LoggerFactory.getLogger(Swap.class);

    @Override
    public String getName() {
        return SWAP_COLUMN_ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMNS.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter("selected_column", ParameterType.COLUMN, "", false, false));
        return parameters;
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        Map parameters = actionContext.getParameters();
        RowMetadata rowMetadata = actionContext.getRowMetadata();
        ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get("selected_column"));
        if (selectedColumn == null) {
            return;
        }
        String domain = selectedColumn.getDomain();
        String type = selectedColumn.getType();
        String columnId = (String)parameters.get(ImplicitParameters.COLUMN_ID.getKey());
        ColumnMetadata originColumn = rowMetadata.getById(columnId);
        selectedColumn.setDomain(originColumn.getDomain());
        selectedColumn.setType(originColumn.getType());
        originColumn.setDomain(domain);
        originColumn.setType(type);
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        Map parameters;
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata selectedColumn = rowMetadata.getById((String)(parameters = context.getParameters()).get("selected_column"));
        if (selectedColumn == null) {
            return;
        }
        String columnId = context.getColumnId();
        LOGGER.debug("swapping columns {} <-> {}", (Object)columnId, (Object)selectedColumn.getId());
        String columnValue = row.get(columnId);
        String selectedColumnValue = row.get(selectedColumn.getId());
        row.set(columnId, selectedColumnValue == null ? "" : selectedColumnValue);
        row.set(selectedColumn.getId(), columnValue == null ? "" : columnValue);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_MULTIPLE_COLUMNS, ActionDefinition.Behavior.METADATA_CHANGE_TYPE);
    }
}

