/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.column;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#type_change")
public class TypeChange
extends AbstractActionMetadata
implements ColumnAction {
    public static final String TYPE_CHANGE_ACTION_NAME = "type_change";
    public static final String NEW_TYPE_PARAMETER_KEY = "new_type";
    private static final Logger LOGGER = LoggerFactory.getLogger(TypeChange.class);

    @Override
    public String getName() {
        return TYPE_CHANGE_ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public String getCategory() {
        return ActionCategory.COLUMN_METADATA.getDisplayName();
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String columnId = context.getColumnId();
            Map parameters = context.getParameters();
            LOGGER.debug("TypeChange for columnId {} with parameters {} ", (Object)columnId, (Object)parameters);
            RowMetadata rowMetadata = context.getRowMetadata();
            ColumnMetadata columnMetadata = rowMetadata.getById(columnId);
            String newType = (String)parameters.get(NEW_TYPE_PARAMETER_KEY);
            if (StringUtils.isNotEmpty((String)newType)) {
                columnMetadata.setType(newType);
                columnMetadata.setTypeForced(true);
                columnMetadata.setDomain("");
                columnMetadata.setDomainLabel("");
                columnMetadata.setDomainFrequency(0.0f);
                columnMetadata.setDomainForced(true);
            }
            rowMetadata.update(columnId, columnMetadata);
            context.setActionStatus(ActionContext.ActionStatus.DONE);
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CHANGE_TYPE);
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
    }
}

