/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.i18n.ActionsBundle;
import org.talend.dataprep.i18n.IMessagesBundle;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.transformation.actions.category.ScopeCategory;
import org.talend.dataprep.transformation.actions.common.CellAction;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.DataSetAction;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.actions.common.InternalActionDefinition;
import org.talend.dataprep.transformation.actions.common.RowAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public abstract class AbstractActionMetadata
implements InternalActionDefinition {
    public static final String ACTION_BEAN_PREFIX = "action#";

    public ActionDefinition adapt(Schema.Field field) {
        return this;
    }

    public ActionDefinition adapt(ScopeCategory scope) {
        return this;
    }

    public abstract String getName();

    public abstract String getCategory();

    public abstract boolean acceptField(Schema.Field var1);

    public String getLabel() {
        return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, this.getName(), new Object[0]);
    }

    public String getDescription() {
        return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, this.getName(), new Object[0]);
    }

    @Override
    public List<String> getActionScope() {
        return new ArrayList<String>();
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public final boolean acceptScope(ScopeCategory scope) {
        switch (scope) {
            case CELL: {
                return this instanceof CellAction;
            }
            case LINE: {
                return this instanceof RowAction;
            }
            case COLUMN: {
                return this instanceof ColumnAction;
            }
            case DATASET: {
                return this instanceof DataSetAction;
            }
        }
        return false;
    }

    public void compile(ActionContext actionContext) {
        RowMetadata input = actionContext.getRowMetadata();
        ScopeCategory scope = actionContext.getScope();
        if (scope != null) {
            switch (scope) {
                case CELL: 
                case COLUMN: {
                    if (input == null || input.getColumns().isEmpty() || input.getById(actionContext.getColumnId()) != null) break;
                    actionContext.setActionStatus(ActionContext.ActionStatus.CANCELED);
                    return;
                }
            }
        }
        actionContext.setActionStatus(ActionContext.ActionStatus.OK);
    }

    public boolean implicitFilter() {
        return true;
    }

    public List<Parameter> getParameters() {
        return ImplicitParameters.getParameters();
    }

    @JsonIgnore
    public abstract Set<ActionDefinition.Behavior> getBehavior();

    @JsonIgnore
    protected IMessagesBundle getMessagesBundle() {
        return ActionsBundle.INSTANCE;
    }

    public Function<GenericRecord, GenericRecord> action(List<Parameter> parameters) {
        return r -> r;
    }
}

