/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.common;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.CompareAction;
import org.talend.dataprep.transformation.actions.common.OtherColumnParameters;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public abstract class AbstractCompareAction
extends AbstractActionMetadata
implements ColumnAction,
OtherColumnParameters,
CompareAction {
    public static final int ERROR_COMPARE_RESULT = Integer.MIN_VALUE;
    public static final String ERROR_COMPARE_RESULT_LABEL = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompareAction.class);

    @Override
    @Nonnull
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)this.getCompareModeSelectParameter());
        parameters.add((Parameter)SelectParameter.Builder.builder().name("mode").item("constant_mode", new Parameter[]{this.getDefaultConstantValue()}).item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, ERROR_COMPARE_RESULT_LABEL, false, false, ERROR_COMPARE_RESULT_LABEL)}).defaultValue("constant_mode").build());
        return parameters;
    }

    protected SelectParameter getCompareModeSelectParameter() {
        return SelectParameter.Builder.builder().name("compare_mode").item("eq").item("ne").item("gt").item("ge").item("lt").item("le").defaultValue("eq").build();
    }

    protected Parameter getDefaultConstantValue() {
        return new Parameter("constant_value", ParameterType.STRING, "2");
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            String compareToLabel;
            String columnId = context.getColumnId();
            RowMetadata rowMetadata = context.getRowMetadata();
            Map parameters = context.getParameters();
            ColumnMetadata column = rowMetadata.getById(columnId);
            String compareMode = this.getCompareMode(parameters);
            if (((String)parameters.get("mode")).equals("constant_mode")) {
                compareToLabel = (String)parameters.get("constant_value");
            } else {
                ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get("selected_column"));
                compareToLabel = selectedColumn.getName();
            }
            context.column("result", r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + "_" + compareMode + "_" + compareToLabel + "?").type(Type.BOOLEAN).build();
                rowMetadata.insertAfter(columnId, c);
                return c;
            });
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        Map parameters = context.getParameters();
        String compareMode = this.getCompareMode(parameters);
        String newColumnId = context.column("result");
        ComparisonRequest comparisonRequest = new ComparisonRequest().setMode(compareMode).setColumnMetadata1(context.getRowMetadata().getById(columnId)).setValue1(row.get(columnId)).setColumnMetadata2(this.getColumnMetadataToCompareWith(parameters, context)).setValue2(this.getValueToCompareWith(parameters, context, row));
        row.set(newColumnId, this.toStringCompareResult(comparisonRequest));
    }

    protected String getCompareMode(Map<String, String> parameters) {
        return parameters.get("compare_mode");
    }

    private String getValueToCompareWith(Map<String, String> parameters, ActionContext context, DataSetRow row) {
        if (parameters.get("mode").equals("constant_mode")) {
            return parameters.get("constant_value");
        }
        ColumnMetadata selectedColumn = context.getRowMetadata().getById(parameters.get("selected_column"));
        return row.get(selectedColumn.getId());
    }

    private ColumnMetadata getColumnMetadataToCompareWith(Map<String, String> parameters, ActionContext context) {
        if (parameters.get("mode").equals("constant_mode")) {
            return null;
        }
        return context.getRowMetadata().getById(parameters.get("selected_column"));
    }

    protected abstract int doCompare(ComparisonRequest var1);

    public String toStringCompareResult(ComparisonRequest comparisonRequest) {
        boolean booleanResult;
        try {
            int result = this.doCompare(comparisonRequest);
            if (result == Integer.MIN_VALUE) {
                return ERROR_COMPARE_RESULT_LABEL;
            }
            booleanResult = this.compareResultToBoolean(result, comparisonRequest.mode);
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Unable to compare values '{}' ", (Object)comparisonRequest, (Object)e);
            return ERROR_COMPARE_RESULT_LABEL;
        }
        return BooleanUtils.toString((boolean)booleanResult, (String)Boolean.TRUE.toString(), (String)Boolean.FALSE.toString());
    }

    protected boolean compareResultToBoolean(int result, String mode) {
        switch (mode) {
            case "eq": {
                return result == 0;
            }
            case "ne": {
                return result != 0;
            }
            case "gt": {
                return result > 0;
            }
            case "ge": {
                return result >= 0;
            }
            case "lt": {
                return result < 0;
            }
            case "le": {
                return result <= 0;
            }
        }
        return false;
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return Collections.singleton(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }

    public static class ComparisonRequest {
        public String value1;
        public String value2;
        public ColumnMetadata colMetadata1;
        public ColumnMetadata colMetadata2;
        public String mode;

        public ComparisonRequest setValue1(String value1) {
            this.value1 = value1;
            return this;
        }

        public ComparisonRequest setValue2(String value2) {
            this.value2 = value2;
            return this;
        }

        public ComparisonRequest setColumnMetadata1(ColumnMetadata colMetadata1) {
            this.colMetadata1 = colMetadata1;
            return this;
        }

        public ComparisonRequest setColumnMetadata2(ColumnMetadata colMetadata2) {
            this.colMetadata2 = colMetadata2;
            return this;
        }

        public ComparisonRequest setMode(String mode) {
            this.mode = mode;
            return this;
        }

        public String toString() {
            return "ComparisonRequest{colMetadata1=" + this.colMetadata1 + ", value1='" + this.value1 + '\'' + ", value2='" + this.value2 + '\'' + ", colMetadata2=" + this.colMetadata2 + ", mode='" + this.mode + '\'' + '}';
        }
    }
}

