/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ReplaceOnValueHelper {
    private ObjectMapper mapper = new ObjectMapper();
    public static final String REGEX_MODE = "regex";
    public static final String EQUALS_MODE = "equals";
    public static final String CONTAINS_MODE = "contains";
    public static final String STARTS_WITH_MODE = "starts_with";
    public static final String ENDS_WITH_MODE = "ends_with";
    private String token;
    private String operator;
    private Pattern pattern;
    private boolean strict = true;

    public ReplaceOnValueHelper() {
    }

    @JsonCreator
    public ReplaceOnValueHelper(@JsonProperty(value="token") String token, @JsonProperty(value="operator") String operator) {
        this.token = token;
        this.operator = operator;
    }

    public ReplaceOnValueHelper build(String jsonString, boolean strict) {
        if (StringUtils.isEmpty((String)jsonString)) {
            throw new InvalidParameterException(jsonString + " is not a valid json");
        }
        try {
            ReplaceOnValueHelper replaceOnValueHelper = (ReplaceOnValueHelper)this.mapper.readValue(jsonString, ReplaceOnValueHelper.class);
            replaceOnValueHelper.setStrict(strict);
            if (replaceOnValueHelper.isValid()) {
                return replaceOnValueHelper;
            }
            throw new IllegalArgumentException();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public String getToken() {
        return this.token;
    }

    public String getOperator() {
        return this.operator;
    }

    public boolean isStrict() {
        return this.strict;
    }

    private void setStrict(boolean strict) {
        this.strict = strict;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    private boolean isValid() {
        Boolean regexMode = this.operator.equals(REGEX_MODE);
        if (regexMode.booleanValue() && this.pattern == null) {
            String actualPattern = this.strict ? this.token : ".*" + this.token + ".*";
            try {
                this.pattern = Pattern.compile(actualPattern, 32);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean matches(String value) {
        if (value == null) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.token) && !this.getOperator().equals(EQUALS_MODE)) {
            return false;
        }
        if (!this.isValid()) {
            return false;
        }
        boolean matches = false;
        switch (this.getOperator()) {
            case "equals": {
                matches = StringUtils.equals((String)value, (String)this.getToken());
                break;
            }
            case "contains": {
                matches = value.contains(this.getToken());
                break;
            }
            case "starts_with": {
                matches = value.startsWith(this.getToken());
                break;
            }
            case "ends_with": {
                matches = value.endsWith(this.getToken());
                break;
            }
            case "regex": {
                Matcher matcher = this.pattern.matcher(value);
                matches = matcher.matches();
            }
        }
        return matches;
    }

    public String toString() {
        return "ReplaceOnValueParameter{token='" + this.token + '\'' + ", operator='" + this.operator + '\'' + ", pattern=" + this.pattern + ", strict=" + this.strict + '}';
    }
}

