/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.datablending;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.DataSetMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.DataSetAction;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.actions.datablending.LookupRowMatcher;
import org.talend.dataprep.transformation.actions.datablending.LookupSelectedColumnParameter;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#lookup")
public class Lookup
extends AbstractActionMetadata
implements DataSetAction {
    public static final String LOOKUP_ACTION_NAME = "lookup";
    private static final Logger LOGGER = LoggerFactory.getLogger(Lookup.class);
    private String adaptedNameValue = "";
    private String adaptedDatasetIdValue = "";

    @Override
    public String getName() {
        return LOOKUP_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATA_BLENDING.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(ImplicitParameters.COLUMN_ID.getParameter());
        parameters.add(ImplicitParameters.FILTER.getParameter());
        parameters.add(new Parameter(Parameters.LOOKUP_DS_NAME.getKey(), ParameterType.STRING, this.adaptedNameValue, false, false, ""));
        parameters.add(new Parameter(Parameters.LOOKUP_DS_ID.getKey(), ParameterType.STRING, this.adaptedDatasetIdValue, false, false, ""));
        parameters.add(new Parameter(Parameters.LOOKUP_JOIN_ON.getKey(), ParameterType.STRING, "", false, false, ""));
        parameters.add(new Parameter(Parameters.LOOKUP_JOIN_ON_NAME.getKey(), ParameterType.STRING, "", false, false, ""));
        parameters.add(new Parameter(Parameters.LOOKUP_SELECTED_COLS.getKey(), ParameterType.LIST, "", false, false, ""));
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return false;
    }

    public Lookup adapt(DataSetMetadata dataset) {
        this.adaptedNameValue = dataset.getName();
        this.adaptedDatasetIdValue = dataset.getId();
        return this;
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            List<LookupSelectedColumnParameter> colsToAdd = this.getColsToAdd(context.getParameters());
            if (colsToAdd.isEmpty()) {
                context.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
            LookupRowMatcher rowMatcher = (LookupRowMatcher)context.get("rowMatcher", (Function)new Function<Map<String, String>, LookupRowMatcher>(){

                @Override
                public LookupRowMatcher apply(Map<String, String> p) {
                    String dataSetId = p.get(Parameters.LOOKUP_DS_ID.getKey());
                    return new LookupRowMatcher(dataSetId);
                }
            });
            Map parameters = context.getParameters();
            String columnId = (String)parameters.get(ImplicitParameters.COLUMN_ID.getKey());
            RowMetadata lookupRowMetadata = rowMatcher.getRowMetadata();
            RowMetadata rowMetadata = context.getRowMetadata();
            colsToAdd.forEach(toAdd -> {
                String toAddColumnId = toAdd.getId();
                ColumnMetadata metadata = lookupRowMetadata.getById(toAddColumnId);
                context.column(toAddColumnId, r -> {
                    ColumnMetadata colMetadata = ColumnMetadata.Builder.column().copy(metadata).computedId(null).build();
                    rowMetadata.insertAfter(columnId, colMetadata);
                    return colMetadata;
                });
            });
        }
    }

    public void applyOnDataSet(DataSetRow row, ActionContext context) {
        Map parameters = context.getParameters();
        String columnId = (String)parameters.get(ImplicitParameters.COLUMN_ID.getKey());
        String joinValue = row.get(columnId);
        String joinOn = (String)parameters.get(Parameters.LOOKUP_JOIN_ON.getKey());
        LookupRowMatcher rowMatcher = (LookupRowMatcher)context.get("rowMatcher");
        DataSetRow matchingRow = rowMatcher.getMatchingRow(joinOn, joinValue);
        List<LookupSelectedColumnParameter> colsToAdd = this.getColsToAdd(parameters);
        colsToAdd.forEach(toAdd -> {
            String newColId = context.column(toAdd.getId());
            row.set(newColId, matchingRow.get(toAdd.getId()));
        });
    }

    private List<LookupSelectedColumnParameter> getColsToAdd(Map<String, String> parameters) {
        try {
            String cols = parameters.get(Parameters.LOOKUP_SELECTED_COLS.getKey());
            return (List)new ObjectMapper().readValue(cols, (TypeReference)new TypeReference<List<LookupSelectedColumnParameter>>(){});
        }
        catch (IOException e) {
            LOGGER.debug("Unable to parse parameter.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }

    public static enum Parameters {
        LOOKUP_DS_NAME,
        LOOKUP_DS_ID,
        LOOKUP_JOIN_ON,
        LOOKUP_JOIN_ON_NAME,
        LOOKUP_SELECTED_COLS;


        public String getKey() {
            return this.name().toLowerCase();
        }
    }
}

