/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.datablending;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.DataSet;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.exception.error.ActionErrorCodes;

public class LookupRowMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(LookupRowMatcher.class);
    private Iterator<DataSetRow> lookupIterator;
    private DataSetRow emptyRow;
    private Map<String, DataSetRow> cache = new HashMap<String, DataSetRow>();

    public LookupRowMatcher(String content) {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(content.getBytes());
            ObjectMapper mapper = new ObjectMapper();
            JsonParser jsonParser = mapper.getFactory().createParser((InputStream)input);
            DataSet lookup = (DataSet)mapper.readerFor(DataSet.class).readValue(jsonParser);
            this.lookupIterator = lookup.getRecords().iterator();
            this.emptyRow = this.getEmptyRow(lookup.getMetadata().getRowMetadata().getColumns());
        }
        catch (IOException e) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.UNABLE_TO_READ_LOOKUP_DATASET, (Throwable)e);
        }
    }

    protected DataSetRow getMatchingRow(String joinOn, String joinValue) {
        if (joinValue == null) {
            LOGGER.debug("join value is null, returning empty row");
            return this.emptyRow;
        }
        if (this.cache.containsKey(joinValue)) {
            return this.cache.get(joinValue);
        }
        while (this.lookupIterator.hasNext()) {
            DataSetRow nextRow = this.lookupIterator.next();
            String nextRowJoinValue = nextRow.get(joinOn);
            if (!this.cache.containsKey(nextRowJoinValue)) {
                this.cache.put(nextRowJoinValue, nextRow.clone());
                LOGGER.trace("row found and cached for {} -> {}", (Object)nextRowJoinValue, (Object)nextRow.values());
            }
            if (!StringUtils.equals((String)joinValue, (String)nextRowJoinValue)) continue;
            return nextRow;
        }
        this.cache.put(joinValue, this.emptyRow);
        LOGGER.trace("no row found for {}, returning an empty row", (Object)joinValue);
        return this.emptyRow;
    }

    public RowMetadata getRowMetadata() {
        return this.emptyRow.getRowMetadata();
    }

    private DataSetRow getEmptyRow(List<ColumnMetadata> columns) {
        RowMetadata rowMetadata = new RowMetadata(columns);
        DataSetRow defaultRow = new DataSetRow(rowMetadata);
        columns.forEach(column -> defaultRow.set(column.getId(), ""));
        return defaultRow;
    }
}

