/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.datamasking;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.dataset.statistics.PatternFrequency;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;
import org.talend.dataquality.datamasking.semantic.ValueDataMasker;

@Action(value="action#mask_data_by_domain")
public class MaskDataByDomain
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ACTION_NAME = "mask_data_by_domain";
    private static final Logger LOGGER = LoggerFactory.getLogger(MaskDataByDomain.class);
    private static final String MASKER = "masker";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATA_MASKING.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.isAssignableFrom(Type.get((String)column.getType()));
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String value = row.get(columnId);
        if (StringUtils.isNotBlank((String)value)) {
            try {
                ValueDataMasker masker = (ValueDataMasker)context.get(MASKER);
                row.set(columnId, masker.maskValue(value));
            }
            catch (Exception e) {
                LOGGER.debug("Unable to process value '{}'.", (Object)value, (Object)e);
            }
        }
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            RowMetadata rowMetadata = actionContext.getRowMetadata();
            String columnId = actionContext.getColumnId();
            ColumnMetadata column = rowMetadata.getById(columnId);
            String domain = column.getDomain();
            Type type = Type.get((String)column.getType());
            LOGGER.trace(">>> type: " + type + " metadata: " + column);
            try {
                if (Type.DATE.equals((Object)type)) {
                    List patternFreqList = column.getStatistics().getPatternFrequencies();
                    List dateTimePatternList = patternFreqList.stream().map(PatternFrequency::getPattern).collect(Collectors.toList());
                    actionContext.get(MASKER, p -> new ValueDataMasker(domain, type.getName(), dateTimePatternList));
                } else {
                    actionContext.get(MASKER, p -> new ValueDataMasker(domain, type.getName()));
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                actionContext.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN, ActionDefinition.Behavior.NEED_STATISTICS_INVALID);
    }
}

