/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.dataquality;

import java.text.Normalizer;
import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#normalize")
public class Normalize
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ACTION_NAME = "normalize";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.STRINGS_ADVANCED.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String value = row.get(columnId);
        if (value != null) {
            row.set(columnId, this.normalize(value));
        }
    }

    protected String normalize(String string) {
        int character;
        String normalized = Normalizer.normalize(string, Normalizer.Form.NFKD);
        StringBuilder result = new StringBuilder();
        int strLen = normalized.length();
        block3: for (int offset = 0; offset < strLen; offset += Character.charCount(character)) {
            character = normalized.codePointAt(offset);
            switch (Character.getType(character)) {
                case 6: 
                case 8: {
                    continue block3;
                }
            }
            result.appendCodePoint(Character.toLowerCase(character));
        }
        return result.toString().trim();
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

