/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.statistics.PatternFrequency;
import org.talend.dataprep.api.dataset.statistics.Statistics;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.date.AbstractDate;
import org.talend.dataprep.transformation.actions.date.DatePattern;
import org.talend.dataprep.transformation.actions.date.DatePatternParamModel;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#change_date_pattern")
public class ChangeDatePattern
extends AbstractDate
implements ColumnAction,
DatePatternParamModel {
    public static final String ACTION_NAME = "change_date_pattern";
    protected static final String FROM_MODE = "from_pattern_mode";
    protected static final String FROM_MODE_CUSTOM = "from_custom_mode";
    protected static final String FROM_CUSTOM_PATTERN = "from_custom_pattern";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeDatePattern.class);
    protected static final String FROM_MODE_BEST_GUESS = "unknown_separators";
    private static final String FROM_DATE_PATTERNS = "from_date_patterns";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name(FROM_MODE).item(FROM_MODE_BEST_GUESS).item(FROM_MODE_CUSTOM, new Parameter[]{new Parameter(FROM_CUSTOM_PATTERN, ParameterType.STRING, "", false, false)}).defaultValue(FROM_MODE_BEST_GUESS).build());
        parameters.addAll(this.getParametersForDatePattern());
        return parameters;
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            this.compileDatePattern(actionContext);
            DatePattern newPattern = (DatePattern)actionContext.get("compiled_datePattern");
            RowMetadata rowMetadata = actionContext.getRowMetadata();
            String columnId = actionContext.getColumnId();
            ColumnMetadata column = rowMetadata.getById(columnId);
            Statistics statistics = column.getStatistics();
            actionContext.get(FROM_DATE_PATTERNS, p -> this.compileFromDatePattern(actionContext));
            PatternFrequency newPatternFrequency = statistics.getPatternFrequencies().stream().filter(patternFrequency -> StringUtils.equals((String)patternFrequency.getPattern(), (String)newPattern.getPattern())).findFirst().orElseGet(() -> {
                PatternFrequency newPatternFreq = new PatternFrequency(newPattern.getPattern(), 0L);
                statistics.getPatternFrequencies().add(newPatternFreq);
                return newPatternFreq;
            });
            long mostUsedPatternCount = this.getMostUsedPatternCount(column);
            newPatternFrequency.setOccurrences(mostUsedPatternCount + 1L);
            rowMetadata.update(columnId, column);
        }
    }

    private List<DatePattern> compileFromDatePattern(ActionContext actionContext) {
        if (actionContext.getParameters() == null) {
            return Collections.emptyList();
        }
        switch ((String)actionContext.getParameters().get(FROM_MODE)) {
            case "unknown_separators": {
                RowMetadata rowMetadata = actionContext.getRowMetadata();
                ColumnMetadata column = rowMetadata.getById(actionContext.getColumnId());
                return this.dateParser.getPatterns(column.getStatistics().getPatternFrequencies());
            }
            case "from_custom_mode": {
                ArrayList<DatePattern> fromPatterns = new ArrayList<DatePattern>();
                fromPatterns.add(new DatePattern((String)actionContext.getParameters().get(FROM_CUSTOM_PATTERN)));
                return fromPatterns;
            }
        }
        return Collections.emptyList();
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        DatePattern newPattern = (DatePattern)context.get("compiled_datePattern");
        String value = row.get(columnId);
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        try {
            LocalDateTime date = this.dateParser.parseDateFromPatterns(value, (List)context.get(FROM_DATE_PATTERNS));
            if (date != null) {
                row.set(columnId, newPattern.getFormatter().format(date));
            }
        }
        catch (DateTimeException e) {
            LOGGER.debug("Unable to parse date {}.", (Object)value, (Object)e);
        }
    }

    private long getMostUsedPatternCount(ColumnMetadata column) {
        List patternFrequencies = column.getStatistics().getPatternFrequencies();
        if (patternFrequencies.isEmpty()) {
            return 1L;
        }
        patternFrequencies.sort((p1, p2) -> Long.compare(p2.getOccurrences(), p1.getOccurrences()));
        return ((PatternFrequency)patternFrequencies.get(0)).getOccurrences();
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN, ActionDefinition.Behavior.METADATA_CHANGE_TYPE, ActionDefinition.Behavior.NEED_STATISTICS_PATTERN);
    }
}

