/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.time.LocalDateTime;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.commons.lang.StringUtils;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractCompareAction;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.CompareAction;
import org.talend.dataprep.transformation.actions.common.OtherColumnParameters;
import org.talend.dataprep.transformation.actions.date.DateParser;

@Action(value="action#compare_dates")
public class CompareDates
extends AbstractCompareAction
implements ColumnAction,
OtherColumnParameters,
CompareAction {
    public static final String ACTION_NAME = "compare_dates";
    public static final String EQ = "date.eq";
    public static final String NE = "date.ne";
    public static final String GT = "date.gt";
    public static final String GE = "date.ge";
    public static final String LT = "date.lt";
    public static final String LE = "date.le";
    protected DateParser dateParser = new DateParser(new AnalyzerService());

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATE.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        Type columnType = Type.get((String)column.getType());
        return Type.DATE.isAssignableFrom(columnType);
    }

    @Override
    protected String getCompareMode(Map<String, String> parameters) {
        String dateCompareMode = parameters.get("compare_mode");
        return StringUtils.substringAfter((String)dateCompareMode, (String)"date.");
    }

    @Override
    protected Parameter getDefaultConstantValue() {
        return new Parameter("constant_value", ParameterType.DATE, "");
    }

    @Override
    protected SelectParameter getCompareModeSelectParameter() {
        return SelectParameter.Builder.builder().name("compare_mode").item(EQ).item(NE).item(GT).item(GE).item(LT).item(LE).defaultValue(EQ).build();
    }

    @Override
    protected int doCompare(AbstractCompareAction.ComparisonRequest comparisonRequest) {
        if (StringUtils.isEmpty((String)comparisonRequest.value1) || StringUtils.isEmpty((String)comparisonRequest.value2)) {
            return Integer.MIN_VALUE;
        }
        try {
            LocalDateTime temporalAccessor1 = this.dateParser.parse(comparisonRequest.value1, comparisonRequest.colMetadata1);
            LocalDateTime temporalAccessor2 = this.dateParser.parse(comparisonRequest.value2, comparisonRequest.mode.equals("constant_mode") ? comparisonRequest.colMetadata2 : comparisonRequest.colMetadata1);
            return temporalAccessor1.compareTo(temporalAccessor2);
        }
        catch (Exception e) {
            return Integer.MIN_VALUE;
        }
    }
}

