/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.statistics.Statistics;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.date.AbstractDate;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#compute_time_since")
public class ComputeTimeSince
extends AbstractDate
implements ColumnAction {
    public static final String TIME_SINCE_ACTION_NAME = "compute_time_since";
    protected static final String SINCE_WHEN_PARAMETER = "since_when";
    protected static final String SPECIFIC_DATE_MODE = "specific_date";
    protected static final String TIME_UNIT_PARAMETER = "time_unit";
    protected static final String SPECIFIC_DATE_PARAMETER = "specific_date";
    protected static final String SINCE_DATE_PARAMETER = "since_date";
    private static final String DATE_PATTERN = "yyyy-MM-dd HH:mm";
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
    private static final String PREFIX = "since_";
    private static final String SUFFIX = "_in_";
    private static final String NOW_SERVER_SIDE_MODE = "now_server_side";
    private static final Logger LOGGER = LoggerFactory.getLogger(ComputeTimeSince.class);

    @Override
    public String getName() {
        return TIME_SINCE_ACTION_NAME;
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name(TIME_UNIT_PARAMETER).item(ChronoUnit.YEARS.name(), "years").item(ChronoUnit.MONTHS.name(), "months").item(ChronoUnit.DAYS.name(), "days").item(ChronoUnit.HOURS.name(), "hours").defaultValue(ChronoUnit.HOURS.name()).build());
        parameters.add((Parameter)SelectParameter.Builder.builder().name(SINCE_WHEN_PARAMETER).canBeBlank(false).item(NOW_SERVER_SIDE_MODE).item("specific_date", new Parameter[]{new Parameter("specific_date", ParameterType.DATE, "", false, false)}).item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, "", false, false)}).defaultValue(NOW_SERVER_SIDE_MODE).build());
        return parameters;
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            Map parameters = context.getParameters();
            String columnId = context.getColumnId();
            ChronoUnit unit = ChronoUnit.valueOf(((String)parameters.get(TIME_UNIT_PARAMETER)).toUpperCase());
            ColumnMetadata column = context.getRowMetadata().getById(columnId);
            context.column("result", r -> {
                ColumnMetadata c = ColumnMetadata.Builder.column().copy(column).computedId("").name(PREFIX + column.getName() + SUFFIX + unit.toString().toLowerCase()).computedId(null).statistics(new Statistics()).type(Type.INTEGER).build();
                context.getRowMetadata().insertAfter(columnId, c);
                return c;
            });
            context.get(SINCE_WHEN_PARAMETER, m -> parameters.containsKey(SINCE_WHEN_PARAMETER) ? (String)parameters.get(SINCE_WHEN_PARAMETER) : NOW_SERVER_SIDE_MODE);
            context.get(SINCE_DATE_PARAMETER, m -> ComputeTimeSince.parseSinceDateIfConstant(parameters));
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String newValue;
        RowMetadata rowMetadata = context.getRowMetadata();
        Map parameters = context.getParameters();
        String columnId = context.getColumnId();
        String newColumnId = context.column("result");
        ChronoUnit unit = ChronoUnit.valueOf(((String)parameters.get(TIME_UNIT_PARAMETER)).toUpperCase());
        try {
            LocalDateTime since;
            String mode;
            switch (mode = (String)context.get(SINCE_WHEN_PARAMETER)) {
                case "other_column_mode": {
                    ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get("selected_column"));
                    String dateToCompare = row.get(selectedColumn.getId());
                    since = this.dateParser.parse(dateToCompare, selectedColumn);
                    break;
                }
                default: {
                    since = (LocalDateTime)context.get(SINCE_DATE_PARAMETER);
                }
            }
            if (since == null) {
                newValue = "";
            } else {
                String value = row.get(columnId);
                LocalDateTime temporalAccessor = this.dateParser.parse(value, context.getRowMetadata().getById(columnId));
                LocalDateTime valueAsDate = LocalDateTime.from(temporalAccessor);
                newValue = String.valueOf(unit.between(valueAsDate, since));
            }
        }
        catch (DateTimeException e) {
            LOGGER.trace("Error on dateTime parsing", (Throwable)e);
            newValue = "";
        }
        row.set(newColumnId, newValue);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }

    private static LocalDateTime parseSinceDateIfConstant(Map<String, String> parameters) {
        LocalDateTime since;
        String mode;
        switch (mode = parameters.containsKey(SINCE_WHEN_PARAMETER) ? parameters.get(SINCE_WHEN_PARAMETER) : NOW_SERVER_SIDE_MODE) {
            case "specific_date": {
                try {
                    since = LocalDateTime.parse(parameters.get("specific_date"), DEFAULT_FORMATTER);
                }
                catch (DateTimeException e) {
                    LOGGER.info("Error parsing input date. The front-end might have supplied a corrupted value.", (Throwable)e);
                    since = null;
                }
                break;
            }
            case "other_column_mode": {
                since = null;
                break;
            }
            default: {
                since = LocalDateTime.now();
            }
        }
        return since;
    }
}

