/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import org.talend.dataprep.parameters.Item;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.date.DatePattern;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public interface DatePatternParamModel {
    public static final String NEW_PATTERN = "new_pattern";
    public static final String CUSTOM_PATTERN = "custom_date_pattern";
    public static final String COMPILED_DATE_PATTERN = "compiled_datePattern";
    public static final Parameter CUSTOM_PATTERN_PARAMETER = new Parameter("custom_date_pattern", ParameterType.STRING, "", false, false);

    default public List<Parameter> getParametersForDatePattern() {
        ResourceBundle patterns = ResourceBundle.getBundle("org.talend.dataprep.transformation.actions.date.date_patterns", Locale.ENGLISH);
        Enumeration<String> keys = patterns.getKeys();
        ArrayList<Item> items = new ArrayList<Item>();
        Item defaultItem = null;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            String value = patterns.getString(key);
            Item item2 = Item.Builder.builder().value(value).build();
            items.add(item2);
            if (!"ISO".equals(key)) continue;
            defaultItem = item2;
        }
        if (defaultItem == null) {
            defaultItem = (Item)items.get(0);
        }
        items.sort((item, t1) -> item.getLabel().compareTo(t1.getLabel()));
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add((Parameter)SelectParameter.Builder.builder().name(NEW_PATTERN).items(items).item("custom", new Parameter[]{CUSTOM_PATTERN_PARAMETER}).defaultValue(defaultItem.getValue()).build());
        return parameters;
    }

    default public DatePattern getDateFormat(Map<String, String> parameters) {
        String pattern = "custom".equals(parameters.get(NEW_PATTERN)) ? parameters.get(CUSTOM_PATTERN) : parameters.get(NEW_PATTERN);
        try {
            if (StringUtils.isEmpty((String)pattern)) {
                throw new IllegalArgumentException();
            }
            return new DatePattern(pattern);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("pattern '" + pattern + "' is not a valid date pattern", iae);
        }
    }

    default public void compileDatePattern(ActionContext actionContext) {
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            try {
                actionContext.get(COMPILED_DATE_PATTERN, p -> this.getDateFormat(actionContext.getParameters()));
            }
            catch (IllegalArgumentException e) {
                actionContext.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
        }
    }
}

