/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.date.AbstractDate;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#extract_date_tokens")
public class ExtractDateTokens
extends AbstractDate
implements ColumnAction {
    public static final String ACTION_NAME = "extract_date_tokens";
    private static final String SEPARATOR = "_";
    private static final String YEAR = "YEAR";
    private static final String MONTH = "MONTH";
    private static final String DAY = "DAY";
    private static final String HOUR_12 = "HOUR_12";
    private static final String HOUR_24 = "HOUR_24";
    private static final String MINUTE = "MINUTE";
    private static final String AM_PM = "AM_PM";
    private static final String SECOND = "SECOND";
    private static final String DAY_OF_WEEK = "DAY_OF_WEEK";
    private static final String DAY_OF_YEAR = "DAY_OF_YEAR";
    private static final String WEEK_OF_YEAR = "WEEK_OF_YEAR";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final DateFieldMappingBean[] DATE_FIELDS = new DateFieldMappingBean[]{new DateFieldMappingBean("YEAR", ChronoField.YEAR), new DateFieldMappingBean("MONTH", ChronoField.MONTH_OF_YEAR), new DateFieldMappingBean("DAY", ChronoField.DAY_OF_MONTH), new DateFieldMappingBean("HOUR_12", ChronoField.HOUR_OF_AMPM), new DateFieldMappingBean("AM_PM", ChronoField.AMPM_OF_DAY), new DateFieldMappingBean("HOUR_24", ChronoField.HOUR_OF_DAY), new DateFieldMappingBean("MINUTE", ChronoField.MINUTE_OF_HOUR), new DateFieldMappingBean("SECOND", ChronoField.SECOND_OF_MINUTE), new DateFieldMappingBean("DAY_OF_WEEK", ChronoField.DAY_OF_WEEK), new DateFieldMappingBean("DAY_OF_YEAR", ChronoField.DAY_OF_YEAR), new DateFieldMappingBean("WEEK_OF_YEAR", ChronoField.ALIGNED_WEEK_OF_YEAR)};
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractDateTokens.class);

    @Override
    @Nonnull
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(YEAR, ParameterType.BOOLEAN, TRUE));
        parameters.add(new Parameter(MONTH, ParameterType.BOOLEAN, TRUE));
        parameters.add(new Parameter(DAY, ParameterType.BOOLEAN, TRUE));
        parameters.add(new Parameter(HOUR_12, ParameterType.BOOLEAN, FALSE));
        parameters.add(new Parameter(AM_PM, ParameterType.BOOLEAN, FALSE));
        parameters.add(new Parameter(HOUR_24, ParameterType.BOOLEAN, TRUE));
        parameters.add(new Parameter(MINUTE, ParameterType.BOOLEAN, TRUE));
        parameters.add(new Parameter(SECOND, ParameterType.BOOLEAN, FALSE));
        parameters.add(new Parameter(DAY_OF_WEEK, ParameterType.BOOLEAN, FALSE));
        parameters.add(new Parameter(DAY_OF_YEAR, ParameterType.BOOLEAN, FALSE));
        parameters.add(new Parameter(WEEK_OF_YEAR, ParameterType.BOOLEAN, FALSE));
        return parameters;
    }

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        if (context.getActionStatus() == ActionContext.ActionStatus.OK) {
            RowMetadata rowMetadata = context.getRowMetadata();
            String columnId = context.getColumnId();
            Map parameters = context.getParameters();
            ColumnMetadata column = rowMetadata.getById(columnId);
            for (DateFieldMappingBean date_field : DATE_FIELDS) {
                if (!Boolean.valueOf((String)parameters.get(date_field.key)).booleanValue()) continue;
                context.column(column.getName() + SEPARATOR + date_field.key, r -> {
                    ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + SEPARATOR + date_field.key).type(Type.INTEGER).empty(column.getQuality().getEmpty()).invalid(column.getQuality().getInvalid()).valid(column.getQuality().getValid()).headerSize(column.getHeaderSize()).build();
                    rowMetadata.insertAfter(columnId, c);
                    return c;
                });
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        RowMetadata rowMetadata = context.getRowMetadata();
        String columnId = context.getColumnId();
        Map parameters = context.getParameters();
        ColumnMetadata column = rowMetadata.getById(columnId);
        HashMap<String, String> dateFieldColumns = new HashMap<String, String>();
        for (DateFieldMappingBean date_field : DATE_FIELDS) {
            if (!Boolean.valueOf((String)parameters.get(date_field.key)).booleanValue()) continue;
            String newColumn = context.column(column.getName() + SEPARATOR + date_field.key);
            dateFieldColumns.put(date_field.key, newColumn);
        }
        String value = row.get(columnId);
        if (value == null) {
            return;
        }
        LocalDateTime temporalAccessor = null;
        try {
            temporalAccessor = this.dateParser.parse(value, context.getRowMetadata().getById(columnId));
        }
        catch (DateTimeException e) {
            LOGGER.debug("Unable to parse date {}.", (Object)value, (Object)e);
        }
        for (DateFieldMappingBean date_field : DATE_FIELDS) {
            if (!Boolean.valueOf((String)parameters.get(date_field.key)).booleanValue()) continue;
            String newValue = "";
            if (temporalAccessor != null && temporalAccessor.isSupported(date_field.field)) {
                newValue = String.valueOf(temporalAccessor.get(date_field.field));
            }
            row.set((String)dateFieldColumns.get(date_field.key), newValue);
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }

    private static class DateFieldMappingBean {
        private final String key;
        private final ChronoField field;

        private DateFieldMappingBean(String key, ChronoField field) {
            this.key = key;
            this.field = field;
        }
    }
}

