/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.exception.error.ActionErrorCodes;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.date.AbstractDate;
import org.talend.dataprep.transformation.actions.date.DatePattern;
import org.talend.dataprep.transformation.actions.date.DatePatternParamModel;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#modify_date")
public class ModifyDate
extends AbstractDate
implements ColumnAction,
DatePatternParamModel {
    public static final String ACTION_NAME = "modify_date";
    protected static final String TIME_UNIT_PARAMETER = "time_unit";
    private static final Logger LOGGER = LoggerFactory.getLogger(ModifyDate.class);
    private static final String PATTERN_CONTEXT_KEY = "pattern";
    private static final String UNIT_CONTEXT_KEY = "time_unit";
    private static final String AMOUNT_CONTEXT_KEY = "amount";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add((Parameter)SelectParameter.Builder.builder().name("time_unit").item(ChronoUnit.YEARS.name()).item(ChronoUnit.MONTHS.name()).item(ChronoUnit.DAYS.name()).item(ChronoUnit.HOURS.name()).defaultValue(ChronoUnit.YEARS.name()).build());
        parameters.add((Parameter)SelectParameter.Builder.builder().name("mode").item("constant_mode", new Parameter[]{new Parameter("constant_value", ParameterType.INTEGER, "1")}).item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, "", false, false, "")}).defaultValue("constant_mode").build());
        return parameters;
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            try {
                actionContext.get(PATTERN_CONTEXT_KEY, p -> RowMetadataUtils.getMostUsedDatePattern((ColumnMetadata)actionContext.getRowMetadata().getById(actionContext.getColumnId())));
                actionContext.get("time_unit", p -> ChronoUnit.valueOf(((String)actionContext.getParameters().get("time_unit")).toUpperCase()));
                if (((String)actionContext.getParameters().get("mode")).equals("constant_mode")) {
                    actionContext.get(AMOUNT_CONTEXT_KEY, p -> this.computeAmount((String)actionContext.getParameters().get("constant_value")));
                }
            }
            catch (IllegalArgumentException e) {
                actionContext.setActionStatus(ActionContext.ActionStatus.CANCELED);
            }
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        long amount;
        String mode;
        String columnId = context.getColumnId();
        String value = row.get(columnId);
        if (StringUtils.isBlank((String)value)) {
            return;
        }
        Map parameters = context.getParameters();
        switch (mode = (String)parameters.get("mode")) {
            case "constant_mode": {
                amount = (Long)context.get(AMOUNT_CONTEXT_KEY);
                break;
            }
            case "other_column_mode": {
                String otherColId = (String)parameters.get("selected_column");
                try {
                    amount = this.computeAmount(row.get(otherColId));
                    break;
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            default: {
                throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)"constant_mode"));
            }
        }
        try {
            DatePattern outputPattern = new DatePattern((String)context.get(PATTERN_CONTEXT_KEY));
            LocalDateTime date = this.dateParser.parse(value, context.getRowMetadata().getById(columnId));
            date = date.plus(amount, (TemporalUnit)context.get("time_unit"));
            row.set(columnId, outputPattern.getFormatter().format(date));
        }
        catch (DateTimeException e) {
            LOGGER.debug("Unable to parse date {}.", (Object)value, (Object)e);
        }
    }

    private long computeAmount(String amount) {
        return BigDecimalParser.toBigDecimal((String)amount).longValue();
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

