/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.date;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.actions.date.DatePattern;
import org.talend.dataprep.transformation.actions.date.DatePatternParamModel;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#timestamp_to_date")
public class TimestampToDate
extends AbstractActionMetadata
implements ColumnAction,
DatePatternParamModel {
    public static final String ACTION_NAME = "timestamp_to_date";
    public static final String APPENDIX = "_as_date";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.INTEGER.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATE.getDisplayName();
    }

    @Override
    public List<Parameter> getParameters() {
        List parameters = ImplicitParameters.getParameters();
        parameters.addAll(this.getParametersForDatePattern());
        return parameters;
    }

    @Override
    public void compile(ActionContext context) {
        super.compile(context);
        this.compileDatePattern(context);
        String columnId = context.getColumnId();
        Map parameters = context.getParameters();
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata column = rowMetadata.getById(columnId);
        context.column(column.getName() + APPENDIX, r -> {
            Type type = "custom".equals(parameters.get("new_pattern")) ? Type.STRING : Type.DATE;
            ColumnMetadata c = ColumnMetadata.Builder.column().name(column.getName() + APPENDIX).type(type).headerSize(column.getHeaderSize()).build();
            rowMetadata.insertAfter(columnId, c);
            return c;
        });
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        RowMetadata rowMetadata = context.getRowMetadata();
        ColumnMetadata column = rowMetadata.getById(columnId);
        String newColumn = context.column(column.getName() + APPENDIX);
        String value = row.get(columnId);
        row.set(newColumn, this.getTimeStamp(value, ((DatePattern)context.get("compiled_datePattern")).getFormatter()));
    }

    protected String getTimeStamp(String from, DateTimeFormatter dateTimeFormatter) {
        try {
            LocalDateTime date = LocalDateTime.ofEpochSecond(Long.parseLong(from), 0, ZoneOffset.UTC);
            return dateTimeFormatter.format(date);
        }
        catch (NumberFormatException e) {
            return "";
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CREATE_COLUMNS);
    }
}

