/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.delete;

import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.common.ReplaceOnValueHelper;
import org.talend.dataprep.transformation.actions.delete.AbstractDelete;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#delete_on_value")
public class DeleteOnValue
extends AbstractDelete {
    public static final String DELETE_ON_VALUE_ACTION_NAME = "delete_on_value";
    public static final String VALUE_PARAMETER = "value";
    private ReplaceOnValueHelper regexParametersHelper = new ReplaceOnValueHelper();

    @Override
    public String getName() {
        return DELETE_ON_VALUE_ACTION_NAME;
    }

    @Override
    @Nonnull
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        parameters.add(new Parameter(VALUE_PARAMETER, ParameterType.REGEX, ""));
        return parameters;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.STRING.equals((Object)Type.get((String)column.getType())) || Type.NUMERIC.isAssignableFrom(Type.get((String)column.getType()));
    }

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            Map parameters = actionContext.getParameters();
            actionContext.get("replaceOnValue", p -> this.regexParametersHelper.build((String)parameters.get(VALUE_PARAMETER), true));
        }
    }

    @Override
    public boolean toDelete(DataSetRow dataSetRow, String columnId, ActionContext context) {
        try {
            ReplaceOnValueHelper helper = (ReplaceOnValueHelper)context.get("replaceOnValue");
            return helper.matches(dataSetRow.get(columnId));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

