/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.fill;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.daikon.exception.ExceptionContext;
import org.talend.daikon.exception.TalendRuntimeException;
import org.talend.daikon.exception.error.ErrorCode;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.RowMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.exception.error.ActionErrorCodes;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.parameters.SelectParameter;
import org.talend.dataprep.quality.AnalyzerService;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.OtherColumnParameters;
import org.talend.dataprep.transformation.actions.date.DateParser;
import org.talend.dataprep.transformation.actions.date.DatePattern;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

public abstract class AbstractFillWith
extends AbstractActionMetadata
implements OtherColumnParameters {
    public static final String DEFAULT_VALUE_PARAMETER = "default_value";
    private static final String DATE_PATTERN = "dd/MM/yyyy HH:mm:ss";
    private static final DateTimeFormatter DEFAULT_FORMATTER = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private static final String DEFAULT_DATE_VALUE = DEFAULT_FORMATTER.format(LocalDateTime.of(1970, Month.JANUARY, 1, 10, 0));
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFillWith.class);
    protected DateParser dateParser = new DateParser(new AnalyzerService());
    protected Type type;

    public abstract boolean shouldBeProcessed(DataSetRow var1, String var2);

    @Override
    public void compile(ActionContext actionContext) {
        super.compile(actionContext);
        if (actionContext.getActionStatus() == ActionContext.ActionStatus.OK) {
            RowMetadata input = actionContext.getRowMetadata();
            this.checkParameters(actionContext.getParameters(), input);
        }
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        Map parameters = context.getParameters();
        String columnId = context.getColumnId();
        ColumnMetadata columnMetadata = context.getRowMetadata().getById(columnId);
        if (this.shouldBeProcessed(row, columnId)) {
            Type type;
            String newValue;
            if (((String)parameters.get("mode")).equals("constant_mode")) {
                newValue = (String)parameters.get(DEFAULT_VALUE_PARAMETER);
            } else {
                RowMetadata rowMetadata = context.getRowMetadata();
                ColumnMetadata selectedColumn = rowMetadata.getById((String)parameters.get("selected_column"));
                newValue = row.get(selectedColumn.getId());
            }
            Type type2 = type = columnMetadata == null ? Type.ANY : Type.get((String)columnMetadata.getType());
            if (type.equals((Object)Type.DATE)) {
                try {
                    LocalDateTime date = this.dateParser.parse(newValue, columnMetadata);
                    String mostUsedDatePattern = RowMetadataUtils.getMostUsedDatePattern((ColumnMetadata)columnMetadata);
                    DateTimeFormatter ourNiceFormatter = mostUsedDatePattern == null ? DEFAULT_FORMATTER : new DatePattern(mostUsedDatePattern).getFormatter();
                    newValue = ourNiceFormatter.format(date);
                }
                catch (DateTimeException e) {
                    LOGGER.debug("Unable to parse date {}.", (Object)row.get(columnId), (Object)e);
                }
            }
            row.set(columnId, newValue);
        }
    }

    @Override
    public List<Parameter> getParameters() {
        List<Parameter> parameters = super.getParameters();
        Parameter constantParameter = null;
        switch (this.type) {
            case NUMERIC: 
            case DOUBLE: 
            case FLOAT: 
            case STRING: {
                constantParameter = new Parameter(DEFAULT_VALUE_PARAMETER, ParameterType.STRING, "");
                break;
            }
            case INTEGER: {
                constantParameter = new Parameter(DEFAULT_VALUE_PARAMETER, ParameterType.INTEGER, "0");
                break;
            }
            case BOOLEAN: {
                constantParameter = SelectParameter.Builder.builder().name(DEFAULT_VALUE_PARAMETER).item("True").item("False").defaultValue("True").build();
                break;
            }
            case DATE: {
                constantParameter = new Parameter(DEFAULT_VALUE_PARAMETER, ParameterType.DATE, DEFAULT_DATE_VALUE, false, false, "");
                break;
            }
        }
        parameters.add((Parameter)SelectParameter.Builder.builder().name("mode").item("constant_mode", new Parameter[]{constantParameter}).item("other_column_mode", new Parameter[]{new Parameter("selected_column", ParameterType.COLUMN, "", false, false, "")}).defaultValue("constant_mode").build());
        return parameters;
    }

    private void checkParameters(Map<String, String> parameters, RowMetadata rowMetadata) {
        if (!parameters.containsKey("mode")) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)"mode"));
        }
        if (parameters.get("mode").equals("constant_mode") && !parameters.containsKey(DEFAULT_VALUE_PARAMETER)) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)DEFAULT_VALUE_PARAMETER));
        }
        if (!(parameters.get("mode").equals("constant_mode") || parameters.containsKey("selected_column") && rowMetadata.getById(parameters.get("selected_column")) != null)) {
            throw new TalendRuntimeException((ErrorCode)ActionErrorCodes.BAD_ACTION_PARAMETER, ExceptionContext.build().put("paramName", (Object)"selected_column"));
        }
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

