/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.fill;

import java.util.Locale;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.i18n.ActionsBundle;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.fill.AbstractFillWith;

@Action(value="action#fillemptywithdefault")
public class FillIfEmpty
extends AbstractFillWith
implements ColumnAction {
    public static final String FILL_EMPTY_ACTION_NAME = "fillemptywithdefault";
    public static final String FILL_EMPTY_BOOLEAN = "fillemptywithdefaultboolean";
    public static final String FILL_EMPTY_DATE = "fillemptywithdefaultdate";
    public static final String FILL_EMPTY_INTEGER = "fillemptywithdefaultinteger";
    public static final String FILL_EMPTY_STRING = "fillemptywithdefault";

    public FillIfEmpty() {
        this(Type.STRING);
    }

    public FillIfEmpty(Type type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return "fillemptywithdefault";
    }

    @Override
    public String getDescription() {
        switch (this.type) {
            case STRING: {
                return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, "fillemptywithdefault", new Object[0]);
            }
            case NUMERIC: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: {
                return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, FILL_EMPTY_INTEGER, new Object[0]);
            }
            case BOOLEAN: {
                return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, FILL_EMPTY_BOOLEAN, new Object[0]);
            }
            case DATE: {
                return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, FILL_EMPTY_DATE, new Object[0]);
            }
        }
        throw new UnsupportedOperationException("Type '" + this.type + "' is not supported.");
    }

    @Override
    public String getLabel() {
        switch (this.type) {
            case STRING: {
                return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, "fillemptywithdefault", new Object[0]);
            }
            case NUMERIC: 
            case DOUBLE: 
            case FLOAT: 
            case INTEGER: {
                return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, FILL_EMPTY_INTEGER, new Object[0]);
            }
            case BOOLEAN: {
                return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, FILL_EMPTY_BOOLEAN, new Object[0]);
            }
            case DATE: {
                return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, FILL_EMPTY_DATE, new Object[0]);
            }
        }
        throw new UnsupportedOperationException("Type '" + this.type + "' is not supported.");
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATA_CLEANSING.getDisplayName();
    }

    @Override
    public boolean shouldBeProcessed(DataSetRow dataSetRow, String columnId) {
        String value = dataSetRow.get(columnId);
        return value == null || value.trim().length() == 0;
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.BOOLEAN.equals((Object)Type.get((String)column.getType())) || Type.DATE.equals((Object)Type.get((String)column.getType())) || Type.INTEGER.equals((Object)Type.get((String)column.getType())) || Type.DOUBLE.equals((Object)Type.get((String)column.getType())) || Type.FLOAT.equals((Object)Type.get((String)column.getType())) || Type.STRING.equals((Object)Type.get((String)column.getType()));
    }

    @Override
    public ActionDefinition adapt(Schema.Field field) {
        if (field == null || !this.acceptField(field)) {
            return this;
        }
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return new FillIfEmpty(Type.valueOf((String)column.getType().toUpperCase()));
    }
}

