/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.fill;

import java.util.Locale;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.i18n.ActionsBundle;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.actions.fill.AbstractFillWith;

@Action(value="action#fillinvalidwithdefault")
public class FillInvalid
extends AbstractFillWith
implements ColumnAction {
    public static final String FILL_INVALID_ACTION_NAME = "fillinvalidwithdefault";
    private static final String FILL_INVALID_BOOLEAN = "fillinvalidwithdefaultboolean";
    private static final String FILL_INVALID_DATE = "fillinvalidwithdefaultdate";
    private static final String FILL_INVALID_NUMERIC = "fillinvalidwithdefaultnumeric";
    private static final String ACTION_PREFIX = "action.";
    private static final String ACTION_DESCRIPTION = ".desc";
    private static final String ACTION_LABEL = ".label";

    public FillInvalid() {
        this(Type.STRING);
    }

    private FillInvalid(Type type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return FILL_INVALID_ACTION_NAME;
    }

    @Override
    public String getDescription() {
        if (Type.BOOLEAN.isAssignableFrom(this.type)) {
            return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, FILL_INVALID_BOOLEAN, new Object[0]);
        }
        if (Type.DATE.isAssignableFrom(this.type)) {
            return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, FILL_INVALID_DATE, new Object[0]);
        }
        if (Type.NUMERIC.isAssignableFrom(this.type)) {
            return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, FILL_INVALID_NUMERIC, new Object[0]);
        }
        return ActionsBundle.INSTANCE.actionDescription(Locale.ENGLISH, FILL_INVALID_ACTION_NAME, new Object[0]);
    }

    @Override
    public String getLabel() {
        if (Type.BOOLEAN.isAssignableFrom(this.type)) {
            return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, FILL_INVALID_BOOLEAN, new Object[0]);
        }
        if (Type.DATE.isAssignableFrom(this.type)) {
            return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, FILL_INVALID_DATE, new Object[0]);
        }
        if (Type.NUMERIC.isAssignableFrom(this.type)) {
            return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, FILL_INVALID_NUMERIC, new Object[0]);
        }
        return ActionsBundle.INSTANCE.actionLabel(Locale.ENGLISH, FILL_INVALID_ACTION_NAME, new Object[0]);
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATA_CLEANSING.getDisplayName();
    }

    @Override
    public boolean shouldBeProcessed(DataSetRow dataSetRow, String columnId) {
        return dataSetRow.isInvalid(columnId);
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.BOOLEAN.isAssignableFrom(Type.get((String)column.getType())) || Type.DATE.isAssignableFrom(Type.get((String)column.getType())) || Type.NUMERIC.isAssignableFrom(Type.get((String)column.getType())) || Type.STRING.isAssignableFrom(Type.get((String)column.getType()));
    }

    @Override
    public ActionDefinition adapt(Schema.Field field) {
        if (field == null || !this.acceptField(field)) {
            return this;
        }
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return new FillInvalid(Type.valueOf((String)column.getType().toUpperCase()));
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        Set<ActionDefinition.Behavior> behaviors = super.getBehavior();
        behaviors.add(ActionDefinition.Behavior.NEED_STATISTICS_INVALID);
        return behaviors;
    }
}

