/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.line;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.parameters.Parameter;
import org.talend.dataprep.parameters.ParameterType;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ImplicitParameters;
import org.talend.dataprep.transformation.actions.common.RowAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#make_line_header")
public class MakeLineHeader
extends AbstractActionMetadata
implements RowAction {
    public static final String ACTION_NAME = "make_line_header";
    public static final String SKIP_UNTIL = "make_line_header_skip_until";
    private static final Logger LOGGER = LoggerFactory.getLogger(MakeLineHeader.class);
    private static final String DEFAULT_TITLE_KEY = "DEFAULT_TITLE_KEY";
    private static final String DEFAULT_TITLE_VALUE_MASK = "Col {0}";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.DATA_CLEANSING.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        return true;
    }

    @Override
    public boolean implicitFilter() {
        return false;
    }

    @Override
    public List<Parameter> getParameters() {
        return Collections.singletonList(new Parameter(SKIP_UNTIL, ParameterType.BOOLEAN, Boolean.TRUE.toString()));
    }

    public void applyOnLine(DataSetRow row, ActionContext context) {
        Map parameters = context.getParameters();
        String skipUntilStr = (String)parameters.get(SKIP_UNTIL);
        boolean skipPreviousRows = StringUtils.isBlank((String)skipUntilStr) || BooleanUtils.toBoolean((String)skipUntilStr);
        long tdpId = row.getTdpId();
        long rowId = NumberUtils.toLong((String)((String)parameters.get(ImplicitParameters.ROW_ID.getKey())), (long)0L);
        if (skipPreviousRows && tdpId < rowId) {
            row.setDeleted(true);
        } else if (context.getFilter().test(row)) {
            this.setHeadersFromRow(row, context);
        } else {
            this.setRemainingRowColumnsNames(context);
        }
    }

    private void setRemainingRowColumnsNames(ActionContext context) {
        ColumnMetadata column;
        Iterator iterator = context.getRowMetadata().getColumns().iterator();
        while (iterator.hasNext() && context.has((column = (ColumnMetadata)iterator.next()).getId())) {
            String newColumnName = (String)context.get(column.getId());
            column.setName(newColumnName);
        }
    }

    private void setHeadersFromRow(DataSetRow row, ActionContext context) {
        LOGGER.debug("Make line header for rowId {} with parameters {} ", (Object)context.getRowId(), (Object)context.getParameters());
        List columns = context.getRowMetadata().getColumns();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            ColumnMetadata column = (ColumnMetadata)columns.get(columnIndex);
            int columnViewIndex = columnIndex + 1;
            String newColumnName = (String)context.get(column.getId(), p -> {
                String name = row.get(column.getId());
                if (StringUtils.isBlank((String)name)) {
                    MessageFormat pattern = (MessageFormat)context.get(DEFAULT_TITLE_KEY, q -> new MessageFormat(DEFAULT_TITLE_VALUE_MASK));
                    name = pattern.format(new Object[]{columnViewIndex});
                }
                return name;
            });
            column.setName(newColumnName);
        }
        row.setDeleted(true);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.METADATA_CHANGE_NAME, ActionDefinition.Behavior.VALUES_ALL);
    }
}

