/*
 * Decompiled with CFR 0.152.
 */
package org.talend.dataprep.transformation.actions.math;

import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.Set;
import org.apache.avro.Schema;
import org.talend.daikon.number.BigDecimalParser;
import org.talend.dataprep.api.action.Action;
import org.talend.dataprep.api.action.ActionDefinition;
import org.talend.dataprep.api.dataset.ColumnMetadata;
import org.talend.dataprep.api.dataset.row.DataSetRow;
import org.talend.dataprep.api.dataset.row.RowMetadataUtils;
import org.talend.dataprep.api.type.Type;
import org.talend.dataprep.transformation.actions.category.ActionCategory;
import org.talend.dataprep.transformation.actions.common.AbstractActionMetadata;
import org.talend.dataprep.transformation.actions.common.ColumnAction;
import org.talend.dataprep.transformation.api.action.context.ActionContext;

@Action(value="action#absolute")
public class Absolute
extends AbstractActionMetadata
implements ColumnAction {
    public static final String ABSOLUTE_ACTION_NAME = "absolute";
    private final Type type;

    public Absolute() {
        this.type = Type.INTEGER;
    }

    public Absolute(Type type) {
        this.type = type;
    }

    private String executeOnLong(String value) {
        try {
            long longValue = Long.parseLong(value);
            return Long.toString(Math.abs(longValue));
        }
        catch (NumberFormatException nfe1) {
            return null;
        }
    }

    private String executeOnFloat(String value) {
        try {
            BigDecimal bd = BigDecimalParser.toBigDecimal((String)value);
            return bd.abs().toPlainString();
        }
        catch (NumberFormatException nfe2) {
            return null;
        }
    }

    @Override
    public String getName() {
        return ABSOLUTE_ACTION_NAME;
    }

    @Override
    public String getCategory() {
        return ActionCategory.MATH.getDisplayName();
    }

    @Override
    public boolean acceptField(Schema.Field field) {
        ColumnMetadata column = RowMetadataUtils.toColumnMetadata((Schema.Field)field);
        return Type.FLOAT.equals((Object)Type.get((String)column.getType())) || Type.DOUBLE.equals((Object)Type.get((String)column.getType())) || Type.INTEGER.equals((Object)Type.get((String)column.getType()));
    }

    public void applyOnColumn(DataSetRow row, ActionContext context) {
        String columnId = context.getColumnId();
        String value = row.get(columnId);
        if (value == null) {
            return;
        }
        String absValueStr = null;
        switch (this.type) {
            case INTEGER: {
                absValueStr = this.executeOnLong(value);
                if (absValueStr != null) break;
                absValueStr = this.executeOnFloat(value);
                break;
            }
            case DOUBLE: 
            case FLOAT: {
                absValueStr = this.executeOnFloat(value);
                if (absValueStr != null) break;
                absValueStr = this.executeOnLong(value);
            }
        }
        if (absValueStr != null) {
            row.set(columnId, absValueStr);
        }
    }

    @Override
    public ActionDefinition adapt(Schema.Field field) {
        if (field == null || !this.acceptField(field)) {
            return this;
        }
        return new Absolute(this.type);
    }

    @Override
    public Set<ActionDefinition.Behavior> getBehavior() {
        return EnumSet.of(ActionDefinition.Behavior.VALUES_COLUMN);
    }
}

